﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/psc.h>
#include <nn/psc/sfdl/psc.sfdl.h>

namespace nn  {
namespace psc {

class SessionManager
{

private:
    int32_t       m_RefCount;
    nn::os::Mutex m_Lock;

    nn::sf::ShimLibraryObjectHolder<nn::psc::sf::IPmService> m_Session =
           NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;

    nn::sf::SimpleAllInOneHipcSubDomainClientManager<nn::psc::MaximumModulesPerProcess + 1> m_Domain =
           NN_SF_SIMPLE_ALL_IN_ONE_HIPC_SUB_DOMAIN_CLIENT_MANAGER_INITIALIZER;

public:
    nn::Result GetObject(nn::sf::SharedPointer<nn::psc::sf::IPmService>* pSharedPointer)
    NN_NOEXCEPT
    {
        nn::Result result;

        std::lock_guard<nn::os::Mutex> lock(m_Lock);

        if (m_RefCount == 0)
        {
            if ((result = m_Domain.InitializeShimLibraryHolder(&m_Session, nn::psc::PmModulePortName)).IsFailure())
            {
                return result;
            }
        }

        m_RefCount++;

        *pSharedPointer = m_Session.GetObject();

        return nn::ResultSuccess();
    }

    void Release()
    NN_NOEXCEPT
    {
        std::lock_guard<nn::os::Mutex> lock(m_Lock);

        if (m_RefCount == 1)
        {
            m_Session.FinalizeHolder();
        }

        m_RefCount--;

        NN_ABORT_UNLESS(m_RefCount >= 0);
    }

    NN_IMPLICIT SessionManager()
    NN_NOEXCEPT :
        m_RefCount(0),
        m_Lock(false)
    {

    }
};

}}
