﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>

#include <nn/nn_Common.h>
#include <nn/util/util_BitPack.h>
#include <nn/os/os_ThreadTypes.h>

#include "profiler_Memory.h"

namespace nn { namespace profiler {

struct SettingsFromThePcGui;

struct WorkArea
{
    // set this before entering the profile loop
    uint8_t* startPtr;              // used for all buffer types
    std::atomic<uint8_t*> curPtr;   // used for all buffer types
    uint8_t* sentinel;              // used for all buffer types
    SettingsFromThePcGui* settings;

    nn::os::ThreadType* thread_to_profile;
    uint32_t time_between_samples;

    uint8_t record_cores;           // used as a bitfield
    uint8_t core_number;            // used as an integer to count the cores

    // booleans
    nn::util::BitPack16 fields;
    enum
    {
        IsUsingPerfCounters,
        SampleUsingPerfCounters,
        UseInfiniteTime,
        RecordPerformanceCounters,
        RecordPerformanceCounterCycles,
        RecordCodeblocksOnly,
        ThreadInSystemCall,
    };

    struct Context
    {
        uintptr_t fp;
        uintptr_t sp;
        uintptr_t lr;
        uintptr_t pc;
    } context;

    std::atomic<int> recordCount;
};


void InitializeWorkAreas();
void FinalizeWorkAreas();


WorkArea* GetWorkAreaForCore(SampleBufferIndex index);
void InitializeCoreWorkArea(SampleBufferIndex index);
void FinalizeCoreWorkArea(SampleBufferIndex index);
bool GetMoreSampleBuffer(SampleBufferIndex index);
bool ObtainAndSetupSampleBuffer(SampleBufferIndex index);
bool CheckAndExpandBuffersIfNeeded(SampleBufferIndex index);


} // profiler
} // nn
