﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>

#include "profiler_Defines.h"
#include "profiler_GnuBuildId.h"


namespace nn { namespace profiler {


class RoModuleDetails : public nn::util::IntrusiveListBaseNode<RoModuleDetails>
{
public:
    uint64_t Address;
    uint64_t Size;
    uint64_t LoadTime;
    uint64_t UnloadTime;
    uintptr_t ModulePointerStart;
    uintptr_t ModulePointerEnd;
    char Name[MaximumFilePathLength];
    GnuBuildId BuildId;

    RoModuleDetails(
        uintptr_t codeData,
        uint64_t address,
        uint64_t size,
        uint64_t loadTime);

protected:
private:
};

typedef nn::util::IntrusiveList<
    RoModuleDetails,
    nn::util::IntrusiveListBaseNodeTraits<RoModuleDetails>
> RoModuleList;
extern RoModuleList gActiveModules;
extern RoModuleList gPastModules;

void ModuleInitialize();
void ModuleFinalize();

void ClearModuleLists();
void BuildActiveModules();
void BuildStaticModules();
void CheckForNewModules();
void CloseActiveModules();

}} // nn::profiler
