﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>

#define ENTRY(x) \
    .section ".text"; \
    .align  2; \
    .globl  x; \
    .type   x, %function; \
x:

#define START_ENTRY(x) \
    .section ".start","xa"; \
    .align  2; \
    .globl  x; \
    .type   x, %function; \
x:

#define EXP_VECTOR_ENTRY(x) \
    .section ".exp_vector","xa"; \
    .align  2; \
    .globl  x; \
    .type   x, %function; \
x:

#define SET_SIZE(x) \
    .size   x, [.-x]


#ifdef NN_BUILD_CONFIG_CPU_CORTEX_A57_AARCH64

// This function is to ensure that any other functions in this file are pulled in by the linker.
ENTRY(_ZN2nn8profiler31EnableInstrumentationTrampolineEv)
    ret
SET_SIZE(_ZN2nn8profiler31EnableInstrumentationTrampolineEv)

ENTRY(_ZN2nn8profiler20InstrumentTrampolineEv)
    // construct a temporary frame buffer
    // we store x0-x7 as we need to preserve them for the instrumented function
    stp		x0, x1, [sp, #-80]!
    stp		x2, x3, [sp, #16]
    stp		x4, x5, [sp, #32]
    stp		x6, x7, [sp, #48]
    stp		x29, x30, [sp, #64]
    add		x29, sp, #64
    
    // call our function to record the instrumented function
    bl		_ZN2nn8profiler25EnterInstrumentedFunctionEv
    
    // destruct the frame buffer
    ldp		x29, x30, [sp, #64]
    ldp		x2, x3, [sp, #16]
    ldp		x4, x5, [sp, #32]
    ldp		x6, x7, [sp, #48]
    ldp		x0, x1, [sp], #80

    // Store the original link register on the stack
    stp     x29, x30, [sp, #-16]!
    mov     x29, sp
    
    // Create a new link register value
    adr     x30, .L1
    
    // nop is replaced with first instruction in the instrumented function
    nop
    
    // nop is replaced with branch to second instruction in instrumented function
    nop
    
.L1:
    ldp     x29, x30, [sp], #16
    
    // construct a temporary frame buffer
    // we store x0-x7 as we need to preserve them for the instrumented function
    stp		x0, x1, [sp, #-80]!
    stp		x2, x3, [sp, #16]
    stp		x4, x5, [sp, #32]
    stp		x6, x7, [sp, #48]
    stp		x29, x30, [sp, #64]
    add		x29, sp, #64
    
    // call our function to record the instrumented function
    bl		_ZN2nn8profiler24ExitInstrumentedFunctionEv
    
    // destruct the frame buffer
    ldp		x29, x30, [sp, #64]
    ldp		x2, x3, [sp, #16]
    ldp		x4, x5, [sp, #32]
    ldp		x6, x7, [sp, #48]
    ldp		x0, x1, [sp], #80
    
    ret

SET_SIZE(_ZN2nn8profiler20InstrumentTrampolineEv)

#endif
