﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/prepo_Service.h>
#include <nn/prepo/detail/ipc/prepo_ServiceName.h>
#include <nn/prepo/detail/service/prepo_PrepoService.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/util/util_LockGuard.h>

namespace nn { namespace prepo { namespace detail { namespace service {

namespace
{
    nn::os::SdkMutexType g_Mutex = NN_OS_SDK_MUTEX_INITIALIZER();

    typedef nn::sf::UnmanagedServiceObject<detail::ipc::IPrepoService, PrepoService> PrepoServiceObject;

    std::aligned_storage<sizeof (PrepoServiceObject)>::type g_Storages[detail::ipc::ServiceCount];
    PrepoServiceObject* g_Objects[detail::ipc::ServiceCount] = {};
}

void InitializeService(int index, const char* serviceName, Bit32 capability) NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_Mutex);

    NN_SDK_REQUIRES_RANGE(index, 0, detail::ipc::ServiceCount);

    NN_SDK_ASSERT_EQUAL(g_Objects[index], nullptr);

    g_Objects[index] = new (&g_Storages[index]) PrepoServiceObject(serviceName, capability);
}

void FinalizeServices() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_Mutex);

    for (int i = 0; i < detail::ipc::ServiceCount; i++)
    {
        if (g_Objects[i])
        {
            g_Objects[i]->~PrepoServiceObject();
            g_Objects[i] = nullptr;
        }
    }
}

nn::sf::SharedPointer<detail::ipc::IPrepoService> GetPrepoService(int index) NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_Mutex);

    NN_SDK_REQUIRES_RANGE(index, 0, detail::ipc::ServiceCount);

    NN_SDK_ASSERT_NOT_NULL(g_Objects[index]);

    return g_Objects[index]->GetShared();
}

}}}}
