﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/am/am_Shim.h>
#include <nn/applet/applet_AppletSystem.h>
#include <nn/pl/pl_VrModeApi.private.h>

namespace nn { namespace pl {

NN_STATIC_ASSERT( oe::MessageRequestToEndVrMode == applet::Message_VrModeDisabledBySystem );

void BeginVrMode() NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    applet::BeginVrModeInternal();
#else
    // 他ビルド環境では何もしない
#endif
}

void EndVrMode() NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    applet::EndVrModeInternal();
#else
    // 他ビルド環境では何もしない
#endif
}

bool IsVrMode() NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    bool isValid;
    NN_ABORT_UNLESS_RESULT_SUCCESS( am::GetCommonStateGetter()->IsVrModeEnabled( &isValid ) );
    return isValid;
#else
    return false;
#endif
}

}} // nn::pl
