﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// Definitions of functions called from the HIPC server process or equivalent, related to the perflog Daemon service.
#include <nn/perflog/sfdl/perflog.sfdl.h>

#include <nn/nn_Common.h>
#include <nn/sf/sf_HipcServer.h>
#include "perflog_CreateDaemon.h"
#include "perflog_ServiceName.h"
#include <nn/perflog/perflog_DaemonHipcServer.h>
#include <type_traits>
#include <new>
#include <nn/nn_SdkAssert.h>


namespace nn { namespace perflog {

namespace { // local-only


// Creates a class that inherits nn::sf::HipcSimpleAllInOneServerManager.Normally, it is all right for this to be empty.
// The nn::sf::HipcSimpleAllInOneServerManager class template centrally manages HIPC server ports and sessions.
// The first parameter of the class template specifies the maximum number of sessions to manage, and the second parameter is the maximum number of ports to manage.
class MyServerManager : public nn::sf::HipcSimpleAllInOneServerManager<30, 1>
{
};

// Initialize using placement new to allow for repeated starting and stopping of the server.
// If repeated starting and stopping is not required, you can place MyServerManager directly.
std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_MyServerManagerStorage;
MyServerManager* g_pMyServerManager = NULL;


} // local-only





// Initializes the server.
void InitializeDaemonServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(!g_pMyServerManager);

    // Instantiate the MyServerManager object.
    g_pMyServerManager = new (&g_MyServerManagerStorage) MyServerManager;

    // Associate a service name with the object obtained by CreateDaemonByDfc() and register it to the system.
    // After you have done this, you can call the nn::sf::CreateHipcProxyByName() function for the specified service name
    // and get the HIPC proxy reference to the specified object.
    // For now, sessionCountMax just needs to be set to a sufficiently large value.
    auto sessionCountMax = 30;
    auto result = g_pMyServerManager->RegisterObjectForPort(CreateDaemonByDfc(), sessionCountMax, PerflogDaemonServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());

    // Start the server manager.
    // Actual server operations, however, must be started by calling LoopAuto or a similar function.
    g_pMyServerManager->Start();
}

// Runs the server message processing loop.
void LoopDaemonServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager);

    // To execute the server processing loop, access the LoopAuto function from the MyServerManager class that you already defined.
    // - Connection request to port
    // - Processing request to session
    g_pMyServerManager->LoopAuto();
}



}}  // nn::perflog
