﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/pdm/detail/pdm_Log.h>
#include <nn/pdm/detail/pdm_Time.h>
#include <nn/pdm/detail/pdm_QueryServiceHelper.h>

namespace nn { namespace pdm { namespace detail {


void QueryServiceHelper::Initialize(nn::pdm::EventTimeData* outValue) NN_NOEXCEPT
{
    outValue->eventIndex = 0;
    outValue->userClockTime = 0;
    outValue->networkClockTime = 0;
}

void QueryServiceHelper::Initialize(PlayStatistics* outValue) NN_NOEXCEPT
{
    outValue->applicationId.value = 0;
    outValue->totalPlayCount = 0;
    outValue->totalPlayTime = 0;
    Initialize(&outValue->firstEventTime);
    Initialize(&outValue->latestEventTime);
}

}}}
