﻿// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.pcv
{
    [ExternalStruct(12, 4)]
    [CppRefPath("<nn/pcv/pcv_Types.h>")]
    public struct ModuleState
    {
    }

    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/pcv/pcv_Types.h>")]
    public struct TemperatureThreshold
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/pcv/pcv_Types.h>")]
    public struct MicroVolt
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/pcv/pcv_Types.h>")]
    public struct PowerControlTarget
    {
    }

    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/pcv/pcv_Types.h>")]
    public struct PowerDomainState
    {
    }
}

namespace nn.pcv.detail
{
    [CppRefPath("\"pcv_IPcvService.h\"")]
    interface IPcvService : IServiceObject
    {
        [MethodId(0)]
        Result SetPowerEnabled(int32_t moduleId, bool enabled);

        [MethodId(1)]
        Result SetClockEnabled(int32_t moduleId, bool enabled);

        [MethodId(2)]
        Result SetClockRate(int32_t moduleId, uint32_t clockRateHz);

        [MethodId(3)]
        Result GetClockRate(Out<uint32_t> pClockRateHz, int32_t moduleId);

        [MethodId(4)]
        Result GetState(Out<ModuleState> pState, int32_t moduleId);

        [MethodId(5)]
        Result GetPossibleClockRates(Out<int32_t> pOutType, OutArray<uint32_t> pOutRates, Out<int_t> pOutCount, int32_t moduleId, int_t maxCount);

        [MethodId(6)]
        Result SetMinVClockRate(int32_t moduleId, uint32_t clockRateHz);

        [MethodId(7)]
        Result SetReset(int32_t moduleId, bool reset);

        [MethodId(8)]
        Result SetVoltageEnabled(int32_t powerDomain, bool enabled);

        [MethodId(9)]
        Result GetVoltageEnabled(Out<bool> pEnabled, int32_t powerDomain);

        [MethodId(10)]
        Result GetVoltageRange(Out<int32_t> pMinVolt, Out<int32_t> pMaxVolt, Out<int32_t> pStepVolt, int32_t powerDomain);

        [MethodId(11)]
        Result SetVoltageValue(int32_t powerDomain, int32_t microVolt);

        [MethodId(12)]
        Result GetVoltageValue(Out<int32_t> pMicroVolt, int32_t powerDomain);

        [MethodId(13)]
        Result GetTemperatureThresholds(OutArray<TemperatureThreshold> pThresholds, Out<int_t> pOutCount, int_t maxCount);

        [MethodId(14)]
        Result SetTemperature(int32_t temperatureMilliC);

        [MethodId(15)]
        Result Initialize();

        [MethodId(16)]
        Result IsInitialized(Out<bool> pOutInitialized);

        [MethodId(17)]
        Result Finalize();

        [MethodId(18)]
        Result PowerOn(PowerControlTarget powerControlTarget, MicroVolt microVolt);

        [MethodId(19)]
        Result PowerOff(PowerControlTarget powerControlTarget);

        [MethodId(20)]
        Result ChangeVoltage(PowerControlTarget powerControlTarget, MicroVolt microVolt);

        [MethodId(21)]
        Result GetPowerClockInfoEvent(Out<NativeHandle> outHandle);

        [MethodId(22)]
        Result GetOscillatorClock(Out<uint32_t> pClockRateHz);

        [MethodId(23)]
        Result GetDvfsTable(OutArray<uint32_t> pOutClocks, OutArray<int32_t> pOutVoltages, Out<int32_t> pOutCount, int32_t moduleId, int32_t maxCount);

        [MethodId(24)]
        Result GetModuleStateTable(OutArray<ModuleState> pOutModuleStates, Out<int32_t> pOutCount, int32_t maxCount);

        [MethodId(25)]
        Result GetPowerDomainStateTable(OutArray<PowerDomainState> pOutPowerDomainStates, Out<int32_t> pOutCount, int32_t maxCount);

        [MethodId(26)]
        Result GetFuseInfo(OutArray<uint32_t> pOutValues, Out<int32_t> pOutCount, int32_t maxCount);

        [MethodId(27)]
        Result GetDramId(Out<uint32_t> pOutDramId);

        [MethodId(28)]
        Result IsPoweredOn(Out<bool> pOutIsPoweredOn, PowerControlTarget powerControlTarget);
    }
}

namespace nn.pcv
{
    [CppRefPath("<nn/pcv/pcv_IImmediateManager.sfdl.h>")]
    interface IImmediateManager : IServiceObject
    {
        [MethodId(0)]
        Result SetClockRate(int32_t moduleId, uint32_t clockRateHz);
    }

    [CppRefPath("<nn/pcv/pcv_IArbitrationManager.sfdl.h>")]
    interface IArbitrationManager : IServiceObject
    {
        [MethodId(0)]
        Result ReleaseControl(int32_t moduleId);
    }
}
