﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/pcv/pcv_Modules.h>
#include <nn/pcv/pcv_PowerDomains.h>
#include <nn/spl/spl_Types.h>

#include <nne/max7762x/max7762x_results.h>
#include <nne/max7762x/max7762x_regulator_Types.h>
#include <nne/vcc/ipids.h>
#include <nne/vcc/vcc_dram_ids.h>
#include <nne/vcc/vcc_results.h>

namespace nn { namespace pcv { namespace driver { namespace detail {

//! nn::pcv::Module 型を IP 型に変換します。
::IP ConvertModuleToIp(nn::pcv::Module module) NN_NOEXCEPT;

//! nne::pcv::PowerDomain 型を nn::max7762x::RegulatorHandle 型に変換します。
nne::max7762x::RegulatorHandle ConvertPowerDomainToRegulatorHandle(nn::pcv::PowerDomain powerDomain) NN_NOEXCEPT;

//! nne::vcc::Result 型を nn::Result 型に変換します。
nn::Result MakeResult(nne::vcc::Result vccResult) NN_NOEXCEPT;

//! nne::max7762x::Result 型を nn::Result 型に変換します。
nn::Result MakeResult(nne::max7762x::Result max7762xResult) NN_NOEXCEPT;

//! nne::spl::DramId 型を nne::vcc::DramId 型に変換します。
nne::vcc::DramId ConvertDramId(nn::spl::DramId dramId) NN_NOEXCEPT;

}}}} // namespace nn::pcv::driver::detail
