﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/pctl_Api.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/detail/pctl_ResultHandler.h>
#include <nn/pctl/detail/ipc/pctl_IpcSession.h>

namespace nn { namespace pctl {

bool CheckFreeCommunicationPermission(bool isShowUi) NN_NOEXCEPT
{
    auto result = detail::ipc::GetService()->CheckFreeCommunicationPermission();
    if (result.IsFailure())
    {
        NN_PCTL_DETAIL_HANDLE_RESULT(result, isShowUi);
        // isShowUi == true の場合、表示後に再チェックを行いその状態を返す
        if (isShowUi && !nn::pctl::ResultCanceled::Includes(result))
        {
            result = detail::ipc::GetService()->CheckFreeCommunicationPermission();
            NN_PCTL_DETAIL_ABORT_IF_UNEXPECTED_RESULT(result);
        }
    }
    return result.IsSuccess();
}

}}
