﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/pctl_IntermittentOperation.h>

#include <nn/bgtc/bgtc_Api.h>
#include <nn/pctl/detail/pctl_Log.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

namespace
{
    nn::bgtc::Interval GetIntermittentTaskIntervalSeconds() NN_NOEXCEPT
    {
        int32_t value = 0;
        auto size = nn::settings::fwdbg::GetSettingsItemValue(&value, sizeof(value), "pctl", "intermittent_task_interval_seconds");
        NN_DETAIL_PCTL_TRACE("[pctl] GetIntermittentTaskIntervalSeconds(): setting value = %d\n", static_cast<int>(value));
        // 10秒未満は短すぎるため既定値を用いるようにする
        if (size != sizeof(value) || value < 10)
        {
            value = static_cast<int32_t>(IntermittentTaskIntervalSeconds);
        }
        NN_DETAIL_PCTL_TRACE("[pctl] GetIntermittentTaskIntervalSeconds(): using value = %d\n", static_cast<int>(value));
        return static_cast<nn::bgtc::Interval>(value);
    }
}

// static
nn::Result IntermittentOperation::NotifyTaskStarting() NN_NOEXCEPT
{
    NN_DETAIL_PCTL_TRACE("[pctl] Calling nn::bgtc::NotifyTaskStarting()\n");
    return nn::bgtc::NotifyTaskStarting();
}

// static
void IntermittentOperation::NotifyTaskFinished() NN_NOEXCEPT
{
    NN_DETAIL_PCTL_TRACE("[pctl] Calling nn::bgtc::NotifyTaskFinished()\n");
    nn::bgtc::NotifyTaskFinished();
}

// static
bool IntermittentOperation::IsInHalfAwake() NN_NOEXCEPT
{
    return nn::bgtc::IsInHalfAwake();
}

// static
void IntermittentOperation::ScheduleTask() NN_NOEXCEPT
{
    nn::bgtc::ScheduleTask(GetIntermittentTaskIntervalSeconds());
}

}}}}}
