﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/pctl/detail/pctl_Log.h>
#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/pctl/detail/service/pctl_ParentalControlServiceFactoryImpl.h>
#include <nn/pctl/detail/service/pctl_ParentalControlServiceImpl.h>
#include <nn/pctl/pctl_ResultSystem.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace pctl { namespace detail { namespace service {

// サイズチェック
static const size_t ObjectSize = sizeof(ParentalControlServiceImpl);
static const size_t SessionSizePadding = 512; // nn::sf レイヤーで加えられるサイズ + マージン
NN_STATIC_ASSERT(ObjectSize + SessionSizePadding <= ParentalControlServiceFactoryImpl::SessionSize);

#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS == NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC
ParentalControlServiceFactoryImpl::ParentalControlServiceFactoryImpl(nn::sf::ExpHeapAllocator* allocator, int capability) NN_NOEXCEPT :
    m_capability(capability)
#else
ParentalControlServiceFactoryImpl::ParentalControlServiceFactoryImpl(nn::sf::ExpHeapAllocator* allocator) NN_NOEXCEPT
#endif
{
    m_Allocator = allocator;
#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS == NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC
#endif
}

ParentalControlServiceFactoryImpl::~ParentalControlServiceFactoryImpl() NN_NOEXCEPT
{
}

// until 3.x.x
nn::Result ParentalControlServiceFactoryImpl::CreateService(nn::sf::Out<nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService>> outService, nn::Bit64 processId) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService> p;
    NN_RESULT_DO(CreateServiceImpl(&p, processId));

    NN_RESULT_DO(p->Initialize());

    outService.Set(std::move(p));
    NN_RESULT_SUCCESS;
}

// since 4.x.x
nn::Result ParentalControlServiceFactoryImpl::CreateServiceWithoutInitialize(nn::sf::Out<nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService>> outService, nn::Bit64 processId) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService> p;
    NN_RESULT_DO(CreateServiceImpl(&p, processId));
    outService.Set(std::move(p));
    NN_RESULT_SUCCESS;
}

nn::Result ParentalControlServiceFactoryImpl::CreateServiceImpl(nn::sf::SharedPointer<nn::pctl::detail::ipc::IParentalControlService>* outService, nn::Bit64 processId) NN_NOEXCEPT
{
#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS == NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC
    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<ipc::IParentalControlService, ParentalControlServiceImpl>(m_Allocator,
        m_capability);
#else
    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<ipc::IParentalControlService, ParentalControlServiceImpl>(m_Allocator,
        ipc::ServiceCapabilityFull); // 単体利用版はフル権限とする
#endif

    NN_RESULT_THROW_UNLESS(p, nn::pctl::ResultOutOfSessionResource());

    NN_RESULT_DO(p.GetImpl().InternalInitialize(processId));

    *outService = std::move(p);

    NN_RESULT_SUCCESS;
}

}}}}
