﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/common/pctl_HttpErrorHandler.h>
#include <nn/pctl/pctl_ResultPrivate.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

nn::Result HandleHttpError(CURLcode code) NN_NOEXCEPT
{
    if (code == CURLE_OK)
    {
        return nn::ResultSuccess();
    }

    switch (code)
    {
    case CURLE_UNSUPPORTED_PROTOCOL:
        return ResultHttpErrorUnsupportedProtocol();
    case CURLE_FAILED_INIT:
        return ResultHttpErrorFailedInit();
    case CURLE_URL_MALFORMAT:
        return ResultHttpErrorUrlMalformat();
    case CURLE_NOT_BUILT_IN:
        return ResultHttpErrorNotBuiltIn();
    case CURLE_COULDNT_RESOLVE_PROXY:
        return ResultHttpErrorCouldntResolveProxy();
    case CURLE_COULDNT_RESOLVE_HOST:
        return ResultHttpErrorCouldntResolveHost();
    case CURLE_COULDNT_CONNECT:
        return ResultHttpErrorCouldntConnect();
    case CURLE_REMOTE_ACCESS_DENIED:
        return ResultHttpErrorRemoteAccessDenied();
    case CURLE_HTTP2:
        return ResultHttpErrorHttp2();
    case CURLE_PARTIAL_FILE:
        return ResultHttpErrorPartialFile();
    case CURLE_QUOTE_ERROR:
        return ResultHttpErrorQuoteError();
    case CURLE_HTTP_RETURNED_ERROR:
        return ResultHttpErrorHttpReturnedError();
    case CURLE_WRITE_ERROR:
        return ResultHttpErrorWriteError();
    case CURLE_UPLOAD_FAILED:
        return ResultHttpErrorUploadFailed();
    case CURLE_READ_ERROR:
        return ResultHttpErrorReadError();
    case CURLE_OUT_OF_MEMORY:
        return ResultHttpErrorOutOfMemory();
    case CURLE_OPERATION_TIMEDOUT:
        return ResultHttpErrorOperationTimedout();
    case CURLE_RANGE_ERROR:
        return ResultHttpErrorRangeError();
    case CURLE_HTTP_POST_ERROR:
        return ResultHttpErrorHttpPostError();
    case CURLE_SSL_CONNECT_ERROR:
        return ResultHttpErrorSslConnectError();
    case CURLE_BAD_DOWNLOAD_RESUME:
        return ResultHttpErrorBadDownloadResume();
    case CURLE_FUNCTION_NOT_FOUND:
        return ResultHttpErrorFunctionNotFound();
    case CURLE_ABORTED_BY_CALLBACK:
        return ResultHttpErrorAbortedByCallback();
    case CURLE_BAD_FUNCTION_ARGUMENT:
        return ResultHttpErrorBadFunctionArgument();
    case CURLE_INTERFACE_FAILED:
        return ResultHttpErrorInterfaceFailed();
    case CURLE_TOO_MANY_REDIRECTS:
        return ResultHttpErrorTooManyRedirects();
    case CURLE_UNKNOWN_OPTION:
        return ResultHttpErrorUnknownOption();
    case CURLE_PEER_FAILED_VERIFICATION:
        return ResultHttpErrorPeerFailedVerification();
    case CURLE_GOT_NOTHING:
        return ResultHttpErrorGotNothing();
    case CURLE_SSL_ENGINE_NOTFOUND:
        return ResultHttpErrorSslEngineNotFound();
    case CURLE_SSL_ENGINE_SETFAILED:
        return ResultHttpErrorSslEngineSetFailed();
    case CURLE_SEND_ERROR:
        return ResultHttpErrorSendError();
    case CURLE_RECV_ERROR:
        return ResultHttpErrorRecvError();
    case CURLE_SSL_CERTPROBLEM:
        return ResultHttpErrorSslCertProblem();
    case CURLE_SSL_CIPHER:
        return ResultHttpErrorSslCipher();
    case CURLE_SSL_CACERT:
        return ResultHttpErrorSslCaCert();
    case CURLE_BAD_CONTENT_ENCODING:
        return ResultHttpErrorBadContentEncoding();
    case CURLE_FILESIZE_EXCEEDED:
        return ResultHttpErrorFileSizeExceeded();
    case CURLE_USE_SSL_FAILED:
        return ResultHttpErrorUseSslFailed();
    case CURLE_SEND_FAIL_REWIND:
        return ResultHttpErrorSendFailRewind();
    case CURLE_SSL_ENGINE_INITFAILED:
        return ResultHttpErrorSslEngineInitFailed();
    case CURLE_LOGIN_DENIED:
        return ResultHttpErrorLoginDenied();
    case CURLE_CONV_FAILED:
        return ResultHttpErrorConvFailed();
    case CURLE_CONV_REQD:
        return ResultHttpErrorConvReqd();
    case CURLE_SSL_CACERT_BADFILE:
        return ResultHttpErrorSslCaCertBadFile();
    case CURLE_SSL_SHUTDOWN_FAILED:
        return ResultHttpErrorSslShutdownFailed();
    case CURLE_AGAIN:
        return ResultHttpErrorAgain();
    case CURLE_SSL_CRL_BADFILE:
        return ResultHttpErrorSslCrlBadFile();
    case CURLE_SSL_ISSUER_ERROR:
        return ResultHttpErrorSslIssuerError();
    case CURLE_CHUNK_FAILED:
        return ResultHttpErrorChunkFailed();
    case CURLE_NO_CONNECTION_AVAILABLE:
        return ResultHttpErrorNoConnectionAvailable();
    case CURLE_SSL_PINNEDPUBKEYNOTMATCH:
        return ResultHttpErrorSslPinnedPubkeyNotMatch();
    case CURLE_SSL_INVALIDCERTSTATUS:
        return ResultHttpErrorSslInvalidCertStatus();
    case CURLE_SSL_CTX_FUNCTION_NOT_SET:
        return ResultHttpErrorSslCtxFunctionNotSet();
    case CURLE_SSL_CTX_INVALID:
        return ResultHttpErrorSslCtxInvalid();
    case CURLE_SSL_CTX_FATAL:
        return ResultHttpErrorSslCtxFatal();
    case CURLE_SSL_ALREADY_CONNECTED:
        return ResultHttpErrorSslAlreadyConnected();
    case CURLE_SSL_INVALID_REFERENCE:
        return ResultHttpErrorSslInvalidReference();
    default:
        return ResultUnexpectedHttpError();
    }
} // NOLINT(impl/function_size)

}}}}}
