﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/pcm/detail/pcm_Log.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace pcm { namespace driver { namespace detail {

class FirmwareDebugSettingsAccessor
{
public:
    //! Firmware Debug Settings を読みます。
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pName, const char* pSettingsName) NN_NOEXCEPT
    {
        size_t targetSize = ::nn::settings::fwdbg::GetSettingsItemValueSize(pSettingsName, pName);
        if ( 0 == targetSize )
        {
            NN_DETAIL_PCM_WARN("Failed to read %s.%s (Value is not written)\n", pSettingsName, pName);
            return;
        }
        else if ( sizeof(T) != targetSize )
        {
            NN_DETAIL_PCM_WARN("Failed to read %s.%s (data size does not match). expected=%d, actual=%d\n", pSettingsName, pName, sizeof(T), targetSize);
            return;
        }

        T temporaryValue;
        if ( sizeof(T) != (::nn::settings::fwdbg::GetSettingsItemValue(&temporaryValue, sizeof(T), pSettingsName, pName)) )
        {
            NN_DETAIL_PCM_WARN("Failed to read %s.%s.\n", pSettingsName, pName);
        }
        else
        {
            *pOutValue = temporaryValue;
        }
    }

    //! SettingsName 省略時は pcm のパラメータを見に行きます。
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pName) NN_NOEXCEPT
    {
        ReadSetting(pOutValue, pName, "pcm");
    }

    //! 文字列型の Firmware Debug Settings を読む。 outputBufferSize が十分でない場合など読み出しに失敗した場合に false を返す。
    bool ReadSettingString(char* pOutBuffer, size_t outputBufferSize, const char* pName, const char* pSettingsName) NN_NOEXCEPT;
    bool ReadSettingString(char* pOutBuffer, size_t outputBufferSize, const char* pName) NN_NOEXCEPT
    {
        return ReadSettingString(pOutBuffer, outputBufferSize, pName, "pcm");
    }
};

}}}} // namespace nn::pcm::driver::detail
