﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Common.h>
#include <nn/os/os_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/pcie/pcie_Standard.h>
#include <nn/pcie/pcie_Types.h>
#include <nn/pcie/pcie_Lib.h>

#include <nnc/os/os_Macro.h>
#include <nnc/nn_Result.h>
#include <nnc/os/os_SystemEvent.h>
#include <nnc/result/result_CConverter.h>
#include <nnc/pcie/pcie_Types.h>
#include <nnc/pcie/pcie_Lib.h>

NN_OS_EXTERN_C nnResult nnpcieInitialize()
{
    nn::Result result = nn::pcie::Initialize();
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieFinalize()
{
    nn::Result result = nn::pcie::Finalize();
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieQueryFunctionsUnregistered(nnpcieFunctionState* pOutFunctionState,
                                                         int32_t*             pOutFunctionStateCount,
                                                         size_t               functionStateBufferSize)
{
    nn::Result result = nn::pcie::QueryFunctions(reinterpret_cast<nn::pcie::FunctionState*>(pOutFunctionState),
                                                 pOutFunctionStateCount,
                                                 functionStateBufferSize);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieRegisterClassDriver(nnpcieClassDriverHandle*       pOutHandle,
                                                  nnosSystemEventType*           pOutEvent,
                                                  const nnpcieClassDriverConfig* pInConfig,
                                                  nnosEventClearMode             eventClearMode)
{
    nn::Result result = nn::pcie::RegisterClassDriver(reinterpret_cast<nn::pcie::ClassDriverHandle*>(pOutHandle),
                                                      reinterpret_cast<nn::os::SystemEventType*>(pOutEvent),
                                                      reinterpret_cast<const nn::pcie::ClassDriverConfig*>(pInConfig),
                                                      static_cast<nn::os::EventClearMode>(eventClearMode));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieUnregisterClassDriver(nnosSystemEventType*    pInEvent,
                                                    nnpcieClassDriverHandle classDriverHandle)
{
    nn::Result result = nn::pcie::UnregisterClassDriver(reinterpret_cast<nn::os::SystemEventType*>(pInEvent),
                                                        static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieQueryFunctions(nnpcieFunctionState*    pOutFunctionState,
                                             int32_t*                pOutFunctionStateCount,
                                             nnpcieClassDriverHandle classDriverHandle,
                                             size_t                  functionStateBufferSize)
{
    nn::Result result = nn::pcie::QueryFunctions(reinterpret_cast<nn::pcie::FunctionState*>(pOutFunctionState),
                                                 pOutFunctionStateCount,
                                                 static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                 functionStateBufferSize);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieAcquireFunction(nnosSystemEventType*     pOutEvent,
                                              nnpcieClassDriverHandle  classDriverHandle,
                                              nnpcieFunctionHandle     functionHandle,
                                              nnosEventClearMode       eventClearMode)
{
    nn::Result result = nn::pcie::AcquireFunction(reinterpret_cast<nn::os::SystemEventType*>(pOutEvent),
                                                  static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                  static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                  static_cast<nn::os::EventClearMode>(eventClearMode));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReleaseFunction(nnosSystemEventType*     pInEvent,
                                              nnpcieClassDriverHandle  classDriverHandle,
                                              nnpcieFunctionHandle     functionHandle)

{
    nn::Result result = nn::pcie::ReleaseFunction(reinterpret_cast<nn::os::SystemEventType*>(pInEvent),
                                                  static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                  static_cast<nn::pcie::FunctionHandle>(functionHandle));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieResetFunction(nnpcieClassDriverHandle       classDriverHandle,
                                            nnpcieFunctionHandle          functionHandle,
                                            nnpcieFunctionResetOptionMask resetOptionMask)

{
    nn::Result result = nn::pcie::ResetFunction(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                static_cast<nn::pcie::FunctionResetOptionMask>(resetOptionMask));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieGetFunctionState(nnpcieFunctionState*    pOutFunctionState,
                                               nnpcieClassDriverHandle classDriverHandle,
                                               nnpcieFunctionHandle    functionHandle)
{
    nn::Result result = nn::pcie::GetFunctionState(reinterpret_cast<nn::pcie::FunctionState*>(pOutFunctionState),
                                                   static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                   static_cast<nn::pcie::FunctionHandle>(functionHandle));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieGetBarProfile(nnpcieBarProfile*       pOutBarProfile,
                                            nnpcieClassDriverHandle classDriverHandle,
                                            nnpcieFunctionHandle    functionHandle,
                                            uint8_t                 bar)
{
    nn::Result result = nn::pcie::GetBarProfile(reinterpret_cast<nn::pcie::BarProfile*>(pOutBarProfile),
                                                static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                bar);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieGetMappedBar(volatile uint8_t**      pOutMappedBar,
                                           nnpcieClassDriverHandle classDriverHandle,
                                           nnpcieFunctionHandle    functionHandle,
                                           uint8_t                 bar)
{
    nn::Result result = nn::pcie::GetMappedBar(pOutMappedBar,
                                               static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                               static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                               bar);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadConfig8(uint8_t*                pOutData8,
                                          nnpcieClassDriverHandle classDriverHandle,
                                          nnpcieFunctionHandle    functionHandle,
                                          size_t                  offset)
{
    nn::Result result = nn::pcie::ReadConfig8(pOutData8,
                                              static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                              static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                              offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadConfig16(uint16_t*              pOutData16,
                                           nnpcieClassDriverHandle classDriverHandle,
                                           nnpcieFunctionHandle    functionHandle,
                                           size_t                  offset)
{
    nn::Result result = nn::pcie::ReadConfig16(pOutData16,
                                               static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                               static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                               offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadConfig32(uint32_t*              pOutData32,
                                           nnpcieClassDriverHandle classDriverHandle,
                                           nnpcieFunctionHandle    functionHandle,
                                           size_t                  offset)
{
    nn::Result result = nn::pcie::ReadConfig32(pOutData32,
                                               static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                               static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                               offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteConfig8(uint8_t                 data8,
                                           nnpcieClassDriverHandle classDriverHandle,
                                           nnpcieFunctionHandle    functionHandle,
                                           size_t                  offset)
{
    nn::Result result = nn::pcie::WriteConfig8(data8,
                                               static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                               static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                               offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteConfig16(uint16_t                data16,
                                            nnpcieClassDriverHandle classDriverHandle,
                                            nnpcieFunctionHandle    functionHandle,
                                            size_t                  offset)
{
    nn::Result result = nn::pcie::WriteConfig16(data16,
                                                static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteConfig32(uint32_t                data32,
                                            nnpcieClassDriverHandle classDriverHandle,
                                            nnpcieFunctionHandle    functionHandle,
                                            size_t                  offset)
{
    nn::Result result = nn::pcie::WriteConfig32(data32,
                                                static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadBarRegion8(uint8_t*                pOutData8,
                                             nnpcieClassDriverHandle classDriverHandle,
                                             nnpcieFunctionHandle    functionHandle,
                                             uint8_t                 bar,
                                             size_t                  offset)
{
    nn::Result result = nn::pcie::ReadBarRegion8(pOutData8,
                                                 static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                 static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                 bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadBarRegion16(uint16_t*                pOutData16,
                                              nnpcieClassDriverHandle classDriverHandle,
                                              nnpcieFunctionHandle    functionHandle,
                                              uint8_t                 bar,
                                              size_t                  offset)
{
    nn::Result result = nn::pcie::ReadBarRegion16(pOutData16,
                                                  static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                  static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                  bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadBarRegion32(uint32_t*                pOutData32,
                                              nnpcieClassDriverHandle classDriverHandle,
                                              nnpcieFunctionHandle    functionHandle,
                                              uint8_t                 bar,
                                              size_t                  offset)
{
    nn::Result result = nn::pcie::ReadBarRegion32(pOutData32,
                                                  static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                  static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                  bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadBarRegion64(uint64_t*               pOutData64,
                                              nnpcieClassDriverHandle classDriverHandle,
                                              nnpcieFunctionHandle    functionHandle,
                                              uint8_t                 bar,
                                              size_t                  offset)
{
    nn::Result result = nn::pcie::ReadBarRegion64(pOutData64,
                                                  static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                  static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                  bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReadBarRegion(void *                  pOutData,
                                            nnpcieClassDriverHandle classDriverHandle,
                                            nnpcieFunctionHandle    functionHandle,
                                            uint8_t                 bar,
                                            size_t                  offset,
                                            nnpcieBusAccessWidth    accessWidth,
                                            size_t                  readSize)
{
    nn::Result result = nn::pcie::ReadBarRegion(pOutData,
                                                static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                bar, offset,
                                                static_cast<nn::pcie::BusAccessWidth>(accessWidth),
                                                readSize);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteBarRegion8(uint8_t                 data8,
                                              nnpcieClassDriverHandle classDriverHandle,
                                              nnpcieFunctionHandle    functionHandle,
                                              uint8_t                 bar,
                                              size_t                  offset)
{
    nn::Result result = nn::pcie::WriteBarRegion8(data8,
                                                  static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                  static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                  bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteBarRegion16(uint16_t                data16,
                                               nnpcieClassDriverHandle classDriverHandle,
                                               nnpcieFunctionHandle    functionHandle,
                                               uint8_t                 bar,
                                               size_t                  offset)
{
    nn::Result result = nn::pcie::WriteBarRegion16(data16,
                                                   static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                   static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                   bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteBarRegion32(uint32_t                data32,
                                               nnpcieClassDriverHandle classDriverHandle,
                                               nnpcieFunctionHandle    functionHandle,
                                               uint8_t                 bar,
                                               size_t                  offset)
{
    nn::Result result = nn::pcie::WriteBarRegion32(data32,
                                                   static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                   static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                   bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteBarRegion64(uint64_t                data64,
                                               nnpcieClassDriverHandle classDriverHandle,
                                               nnpcieFunctionHandle    functionHandle,
                                               uint8_t                 bar,
                                               size_t                  offset)
{
    nn::Result result = nn::pcie::WriteBarRegion64(data64,
                                                   static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                   static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                   bar, offset);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieWriteBarRegion(const void*             pInData,
                                             nnpcieClassDriverHandle classDriverHandle,
                                             nnpcieFunctionHandle    functionHandle,
                                             uint8_t                 bar,
                                             size_t                  offset,
                                             nnpcieBusAccessWidth    accessWidth,
                                             size_t                  writeSize)
{
    nn::Result result = nn::pcie::WriteBarRegion(pInData,
                                                 static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                 static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                 bar, offset,
                                                 static_cast<nn::pcie::BusAccessWidth>(accessWidth),
                                                 writeSize);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieFindCapability(size_t*                 pOutOffset,
                                             nnpcieClassDriverHandle classDriverHandle,
                                             nnpcieFunctionHandle    functionHandle,
                                             uint8_t                 capabilityId)
{
    nn::Result result = nn::pcie::FindCapability(pOutOffset,
                                                 static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                 static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                 static_cast<nn::pcie::CapabilityId>(capabilityId));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieFindExtendedCapability(size_t*                 pOutOffset,
                                                     nnpcieClassDriverHandle classDriverHandle,
                                                     nnpcieFunctionHandle    functionHandle,
                                                     uint8_t                 extendedCapabilityId)
{
    nn::Result result = nn::pcie::FindExtendedCapability(pOutOffset,
                                                         static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                         static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                         static_cast<nn::pcie::ExtendedCapabilityId>(extendedCapabilityId));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieMapDma(nnpcieBusAddress*       pOutBusAddress,
                                     nnpcieClassDriverHandle classDriverHandle,
                                     nnpcieFunctionHandle    functionHandle,
                                     nnpcieDmaDirection      direction,
                                     void*                   base,
                                     size_t                  size)
{
    nn::Result result = nn::pcie::MapDma(reinterpret_cast<nn::pcie::BusAddress*>(pOutBusAddress),
                                         static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                         static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                         static_cast<nn::pcie::DmaDirection>(direction),
                                         base, size);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieUnmapDma(nnpcieClassDriverHandle classDriverHandle,
                                       nnpcieFunctionHandle    functionHandle,
                                       void*                   base)
{
    nn::Result result = nn::pcie::UnmapDma(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                           static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                           base);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieUnmapDmaBusAddress(nnpcieClassDriverHandle classDriverHandle,
                                                 nnpcieFunctionHandle    functionHandle,
                                                 nnpcieBusAddress        busAddress)
{
    nn::Result result = nn::pcie::UnmapDma(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                           static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                           static_cast<nn::pcie::BusAddress>(busAddress));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieGetDmaBusAddress(nnpcieBusAddress*       pOutBusAddress,
                                               nnpcieClassDriverHandle classDriverHandle,
                                               nnpcieFunctionHandle    functionHandle,
                                               void*                   address,
                                               size_t                  size)
{
    nn::Result result = nn::pcie::GetDmaBusAddress(reinterpret_cast<nn::pcie::BusAddress*>(pOutBusAddress),
                                                   static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                   static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                   address, size);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieGetDmaBusAddressRange(nnpcieBusAddress*       pOutBase,
                                                    nnpcieBusAddress*       pOutSize,
                                                    nnpcieClassDriverHandle classDriverHandle,
                                                    nnpcieFunctionHandle    functionHandle)
{
    nn::Result result = nn::pcie::GetDmaBusAddressRange(reinterpret_cast<nn::pcie::BusAddress*>(pOutBase),
                                                        reinterpret_cast<nn::pcie::BusAddress*>(pOutSize),
                                                        static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                        static_cast<nn::pcie::FunctionHandle>(functionHandle));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieSetDmaEnable(nnpcieClassDriverHandle classDriverHandle,
                                           nnpcieFunctionHandle    functionHandle,
                                           bool                    isBusMasterEnabled)
{
    nn::Result result = nn::pcie::SetDmaEnable(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                               static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                               isBusMasterEnabled);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieAcquireIrq(nnosSystemEventType*     pOutEvent,
                                         nnpcieClassDriverHandle  classDriverHandle,
                                         nnpcieFunctionHandle     functionHandle,
                                         nnosEventClearMode       eventClearMode,
                                         nnpcieIrqType            irqType)
{
    nn::Result result = nn::pcie::AcquireIrq(reinterpret_cast<nn::os::SystemEventType*>(pOutEvent),
                                             static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                             static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                             static_cast<nn::os::EventClearMode>(eventClearMode),
                                             static_cast<nn::pcie::IrqType>(irqType));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieReleaseIrq(nnosSystemEventType*     pInEvent,
                                         nnpcieClassDriverHandle  classDriverHandle,
                                         nnpcieFunctionHandle     functionHandle)
{
    nn::Result result = nn::pcie::ReleaseIrq(reinterpret_cast<nn::os::SystemEventType*>(pInEvent),
                                             static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                             static_cast<nn::pcie::FunctionHandle>(functionHandle));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieSetIrqEnable(nnpcieClassDriverHandle classDriverHandle,
                                           nnpcieFunctionHandle    functionHandle,
                                           int32_t                 zeroBasedIrqNumber,
                                           bool                    isIrqEnabled)
{
    nn::Result result = nn::pcie::SetIrqEnable(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                               static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                               zeroBasedIrqNumber,isIrqEnabled);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieSetAspmEnable(nnpcieClassDriverHandle classDriverHandle,
                                            nnpcieFunctionHandle    functionHandle,
                                            bool                    isEnabled)
{
    nn::Result result = nn::pcie::SetAspmEnable(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                isEnabled);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C nnResult nnpcieSetResetUponResumeEnable(nnpcieClassDriverHandle classDriverHandle,
                                                       nnpcieFunctionHandle    functionHandle,
                                                       bool                    isEnabled)
{
    nn::Result result = nn::pcie::SetResetUponResumeEnable(static_cast<nn::pcie::ClassDriverHandle>(classDriverHandle),
                                                           static_cast<nn::pcie::FunctionHandle>(functionHandle),
                                                           isEnabled);
    return nn::result::ConvertToC(result);
}

