﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Utilities
 *
 * @details General utilies not associated with any specific
 *          instances
 */

namespace nn { namespace pcie { namespace driver { namespace detail {

Result GetMemoryBusAddressess(void *address, size_t size, BusAddress *pRetBusAddress);
bool IsPowerOfTwo(int32_t value);
int32_t FindLastSetBit(int32_t mask32);
int32_t FindFirstSetBit(int32_t mask32);
size_t RoundupSize(size_t inputSize, size_t powerOfTwoRoundedSize);
const char* GetBusSpeedDescription(BusSpeed speed);
const char* GetPmStateDescription(PmState pmState);
uint32_t AddSaturated(uint32_t a, uint32_t b);
void IncrementSaturated(uint32_t & value);

} // namespace detail
} // namespace driver
} // namespace pcie
} // namespace nn
