﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <cstring>
#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_StringUtil.h>
#include <nn/os.h>
#include <nn/os/os_SdkThreadCommon.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_MemoryFence.h>
#include <nn/dd.h>
#include <nn/psc.h>
#include <nn/gpio/gpio.h>
#include <nn/pcv/pcv.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include <nn/pcie/pcie.h>
#include <nn/pcie/pcie_LoggedState.h>
#include <nn/pcie/driver/pcie.h>
#include "../../detail/pcie_Macros.h"
#include "../../detail/pcie_Memory.h"

#include "pcie_LocalEvent.h"
#include "pcie_IoVaManager.h"
#include "pcie_SafeHandleManager.h"
#include "pcie_PrivateTypes.h"
#include "pcie_StaticConfig.h"
#include "pcie_Utilities.h"
#include "pcie_IrqManager.h"
#include "pcie_Function.h"
#include "pcie_Device.h"
#include "pcie_Bus.h"
#include "pcie_RootComplex.h"
#include "pcie_Endpoint.h"
#include "pcie_Bridge.h"
#include "pcie_Client.h"
#include "pcie_Driver.h"




