﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/olsc/srv/util/olsc_SaveData.h>

#include <nn/fs/fs_Utility.h>

namespace nn { namespace olsc { namespace srv { namespace util {

nn::util::optional<nn::fs::SaveDataInfo> FindSaveData(const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT
{
    auto pred = [&uid, appId](const fs::SaveDataInfo& info) -> auto {
        return true
            && info.saveDataType == fs::SaveDataType::Account
            && info.applicationId.value == appId.value
            && info.saveDataUserId == fs::ConvertAccountUidToFsUserId(uid);
    };
    return FindSaveData(fs::SaveDataSpaceId::User, pred);
}

}}}} //namespace nn::olsc::srv::util
