﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_Result.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/os/os_MultipleWaitUtility.h>
#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_ResultPrivate.h>
#include <nn/olsc/srv/util/olsc_Account.h>
#include <nn/olsc/srv/util/olsc_CancelListener.h>
#include <nn/olsc/srv/util/olsc_Os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_ScopeExit.h>

namespace nn { namespace olsc { namespace srv { namespace util {

namespace {
    const account::SystemProgramIdentification Identification = {
        { 0x010000000000003e },
        0
    };
} // namespace

Result GetNsaIdToken(size_t* outSize, char* out, size_t maxOutSize, const account::Uid& uid, nn::util::Cancelable& cancelable) NN_NOEXCEPT
{
    account::NetworkServiceAccountManager nsaManager;
    NN_RESULT_DO(account::GetNetworkServiceAccountManager(&nsaManager, uid));

    nsaManager.SetSystemProgramIdentification(Identification);
    account::AsyncContext asyncContext;
    NN_RESULT_DO(nsaManager.EnsureNetworkServiceAccountIdTokenCacheAsync(&asyncContext));

    SimpleCancelListener cancelListener;
    cancelable.AttachListener(&cancelListener);
    NN_UTIL_SCOPE_EXIT {
        cancelable.DetachListener();
    };

    auto& cancelEvent = cancelListener.GetEvent();
    nn::os::SystemEvent asyncEvent;
    NN_RESULT_DO(asyncContext.GetSystemEvent(&asyncEvent));

    const int CancelIndex = 0;
    const int AsyncDoneIndex = 1;
    auto signaled = os::WaitAny(cancelEvent.GetBase(), asyncEvent.GetBase());
    switch (signaled)
    {
        case CancelIndex:
            asyncContext.Cancel();
            asyncEvent.Wait();
            NN_FALL_THROUGH;

        case AsyncDoneIndex:
            NN_RESULT_TRY(asyncContext.GetResult())
                NN_RESULT_CATCH_CONVERT(account::ResultCancelled, olsc::ResultCanceledDuringNsaLogin())
            NN_RESULT_END_TRY;
            break;

        default:
            NN_UNEXPECTED_DEFAULT;
    }

    NN_RESULT_DO(nsaManager.LoadNetworkServiceAccountIdTokenCache(outSize, out, maxOutSize));
    NN_RESULT_SUCCESS;
}

}}}} //namespace nn::olsc::srv::util
