﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/olsc/srv/olsc_Executor.h>
#include <nn/olsc/srv/olsc_PolicyInfoTask.h>
#include <nn/olsc/srv/transfer/olsc_PolicyInfoDownload.h>
#include <nn/olsc/srv/util/olsc_ApplicationVersion.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace olsc { namespace srv {
namespace {


    database::PolicyInfoCacheEntry MakePolicyInfoCacheEntry(int launchVersion, int latestVersion, const PolicyInfo& piForLaunchVersion, const PolicyInfo& piForLatestVersion) NN_NOEXCEPT
    {
        auto type = (piForLaunchVersion.type == PolicyType::AllOk && piForLatestVersion.type == PolicyType::AllOk)
            ? PolicyType::AllOk
            : PolicyType::AllNg;
        PolicyInfo pi = { type };

        return {
            launchVersion,
            latestVersion,
            pi,
        };
    }

    struct Buffer
    {
        std::array<char, 16 * 1024> ioBuffer;
    };


} // namespace

Result UpdateDataTransferPolicyTask::ExecuteImpl(void *rawBuffer, size_t rawBufferSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(rawBufferSize >= sizeof(ExecutionResource));
    auto er = reinterpret_cast<ExecutionResource*>(rawBuffer);

    NN_SDK_ASSERT(er->BufferSize >= sizeof(Buffer));
    auto buffer = reinterpret_cast<Buffer*>(er->buffer);

    PolicyInfo piForLaunchRequiredVersion;
    NN_RESULT_DO(transfer::GetPolicyInfo(&piForLaunchRequiredVersion, m_AppId, m_LaunchRequiredVersion, er->curlHandle, buffer->ioBuffer.data(), buffer->ioBuffer.size(), this));

    PolicyInfo piForLatestVersion;
    if (m_LatestVerison != m_LaunchRequiredVersion)
    {
        NN_RESULT_DO(transfer::GetPolicyInfo(&piForLatestVersion, m_AppId, m_LatestVerison, er->curlHandle, buffer->ioBuffer.data(), buffer->ioBuffer.size(), this));
    }
    else
    {
        piForLatestVersion = piForLaunchRequiredVersion;
    }

    auto entry = MakePolicyInfoCacheEntry(m_LaunchRequiredVersion, m_LatestVerison, piForLaunchRequiredVersion, piForLatestVersion);
    auto writeMount = m_PolicyInfoCache.AcquireWriteMount();
    m_PolicyInfoCache.Add(m_AppId, entry);
    NN_RESULT_DO(writeMount.Commit());

    NN_RESULT_SUCCESS;
}


}}} //namespace nn::olsc::srv

