﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/json/http_JsonPath.h>
#include <nn/nn_Result.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>
#include "olsc_OutputStream.h"
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace olsc { namespace srv { namespace adaptor {

class SaveDataArchiveInfoBuilder
{
public:
    static const int MaxPropertyCount = 32;

    SaveDataArchiveInfoBuilder() NN_NOEXCEPT;
    void Reset() NN_NOEXCEPT;
    bool Validate() NN_NOEXCEPT;
    const SaveDataArchiveInfo& GetSaveDataArchiveInfo() const NN_NOEXCEPT;
    template<typename FlagType>
    void SetFlag() NN_NOEXCEPT;

    template<typename FlagType>
    bool IsUnset() const NN_NOEXCEPT;

    void SetId(SaveDataArchiveId saveDataArchiveId) NN_NOEXCEPT;
    void SetNsaId(account::NetworkServiceAccountId nsaId) NN_NOEXCEPT;
    void SetApplicationId(ApplicationId applicationId) NN_NOEXCEPT;
    void SetUaId(const account::Uid& userId) NN_NOEXCEPT;
    void SetDeviceId(DeviceId deviceId) NN_NOEXCEPT;
    void SetDataSize(uint32_t dataSize) NN_NOEXCEPT;
    void SetAutoBackup(bool autoBackup) NN_NOEXCEPT;
    void SetHasThumbnail(bool hasThumbnail) NN_NOEXCEPT;
    void SetEncodedDigest(const char digest[], size_t digestSize) NN_NOEXCEPT;
    void SetStatus(SaveDataArchiveStatus status) NN_NOEXCEPT;
    void SetLaunchRequiredVersion(uint32_t launchRequiredVersion) NN_NOEXCEPT;
    void SetNumOfPartitions(uint32_t numOfPartitions) NN_NOEXCEPT;
    void SetSeriesId(Bit64 seriesId) NN_NOEXCEPT;
    void SetSavedAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;
    void SetTimeoutAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;
    void SetFinishedAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;
    void SetCreatedAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;
    void SetUpdatedAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;

private:
    SaveDataArchiveInfo m_SaveDataArchiveInfo;
    nn::util::BitFlagSet<MaxPropertyCount> m_Imported;

};

class SaveDataArchiveInfoAdaptor
    : public AdaptorBase<8, 128>
{
public:
    NN_IMPLICIT SaveDataArchiveInfoAdaptor(SaveDataArchiveInfoOutputStreamBase* outputStream) NN_NOEXCEPT
        : m_OutputStream(outputStream)
    {}

    virtual bool UpdateImpl(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, uint64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;

    static const int MaxPathLength = 64;

private:
    bool MakeAndCheckObjectPath(char* buffer, size_t bufferSize, const JsonPathType& jsonPath) NN_NOEXCEPT;

private:
    SaveDataArchiveInfoOutputStreamBase* m_OutputStream;
    SaveDataArchiveInfoBuilder m_Builder;

    // 単体の SDA パース時には GetResult で Error を検出できるようにするフラグ
    // TODO : このフラグが必要ないようなアダプタの検討
    bool m_IsSingleSda = false;

    int m_CurrentIndex = 0;
    char m_PathBuffer[MaxPathLength];
    int m_PathBufferLength = 0;
    bool m_IsAcceptable = false;
};

}}}} // namespace nn::olsc::srv::adaptor
