﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_StaticAssert.h>

#include <nn/oe/oe_DebugApis.h>

#include <nn/am/am_Shim.h>
#include <nn/ncm/ncm_StorageId.h>

namespace nn { namespace oe {

//-----------------------------------------------------------------------------

namespace {

NN_STATIC_ASSERT(StorageTypeForDebug_Unknown != StorageTypeForDebug_None);
NN_STATIC_ASSERT(StorageTypeForDebug_None == static_cast<StorageTypeForDebug>(ncm::StorageId::None));
NN_STATIC_ASSERT(StorageTypeForDebug_Host == static_cast<StorageTypeForDebug>(ncm::StorageId::Host));
NN_STATIC_ASSERT(StorageTypeForDebug_GameCard == static_cast<StorageTypeForDebug>(ncm::StorageId::Card));
NN_STATIC_ASSERT(StorageTypeForDebug_BuiltInStorage == static_cast<StorageTypeForDebug>(ncm::StorageId::BuildInUser));
NN_STATIC_ASSERT(StorageTypeForDebug_SdCard == static_cast<StorageTypeForDebug>(ncm::StorageId::SdCard));

StorageTypeForDebug ConvertStorageIdToStorageType(ncm::StorageId storageId) NN_NOEXCEPT
{
    switch (storageId)
    {
    case ncm::StorageId::None:
    case ncm::StorageId::Host:
    case ncm::StorageId::Card:
    case ncm::StorageId::BuildInUser:
    case ncm::StorageId::SdCard:
            return static_cast<StorageTypeForDebug>( storageId );

    default:
            break;
    }

    return StorageTypeForDebug_Unknown;
}

}   // namespace anonymous

//-----------------------------------------------------------------------------
// アプリケーションの起動デバイス情報を取得
//
void GetLaunchStorageInfoForDebug(LaunchStorageInfoForDebug* pInfo) NN_NOEXCEPT
{
    auto launchStorage = ncm::StorageId::None;
    auto patchStorage  = ncm::StorageId::None;
    NN_ABORT_UNLESS_RESULT_SUCCESS( am::GetApplicationFunctions()->GetLaunchStorageInfoForDebug(&launchStorage, &patchStorage) );
    NN_ABORT_UNLESS(launchStorage != ncm::StorageId::None);

    pInfo->launchStorage = ConvertStorageIdToStorageType(launchStorage);
    pInfo->patchStorage  = ConvertStorageIdToStorageType(patchStorage);
}

void EnableAllThreadDumpOnCrashForDebug(bool isEnabled) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS( am::GetApplicationFunctions()->EnableApplicationAllThreadDumpOnCrash(isEnabled) );
}


}}  // namespace nn::oe

