﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ntc/detail/service/ntc_StaticService.h>
#include <nn/ntc/detail/service/ntc_EnsureNetworkClockAvailabilityService.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

namespace nn { namespace ntc { namespace detail { namespace service {

StaticService::StaticService(detail::service::AutonomicEnsureNetworkClockAvailabilityThread* pAutonomicEnsureNetworkClockAvailabilityThread) NN_NOEXCEPT:
    m_pAutonomicEnsureNetworkClockAvailabilityThread(pAutonomicEnsureNetworkClockAvailabilityThread)
{
}

nn::Result StaticService::GetEnsureNetworkClockAvailabilityService(
        nn::sf::Out<nn::sf::SharedPointer<IEnsureNetworkClockAvailabilityService>> outService,
        int32_t ensureNetworkClockAvailabilityMode,
        const nn::nifm::ClientId& nifmClientId
        ) NN_NOEXCEPT
{
    nn::sf::SharedPointer<IEnsureNetworkClockAvailabilityService> returnService;
    switch (static_cast<nn::ntc::EnsureNetworkClockAvailabilityMode>(ensureNetworkClockAvailabilityMode))
    {
        case EnsureNetworkClockAvailabilityMode_Default:
            returnService = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
                CreateSharedEmplaced<IEnsureNetworkClockAvailabilityService, DefaultEnsureNetworkClockAvailabilityService>(m_SfExpHeapAllocator.GetBase(), nifmClientId);
        break;
        case EnsureNetworkClockAvailabilityMode_ForcibleDownload:
            returnService = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
                CreateSharedEmplaced<IEnsureNetworkClockAvailabilityService, ForcibleDownloadEnsureNetworkClockAvailabilityService>(m_SfExpHeapAllocator.GetBase(), nifmClientId);
        break;
        case EnsureNetworkClockAvailabilityMode_GetServerTime:
            returnService = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
                CreateSharedEmplaced<IEnsureNetworkClockAvailabilityService, ServerTimeGetterService>(m_SfExpHeapAllocator.GetBase(), nifmClientId);
        break;
        default:
            NN_RESULT_THROW(nn::time::ResultNotImplemented());
    }

    NN_RESULT_THROW_UNLESS(returnService, nn::time::ResultOutOfMemory());

    *outService = std::move(returnService);
    NN_RESULT_SUCCESS;
}

Result StaticService::SuspendAutonomicTimeCorrection() NN_NOEXCEPT
{
    if(!m_pAutonomicEnsureNetworkClockAvailabilityThread)
    {
        NN_RESULT_SUCCESS;
    }

    NN_RESULT_DO(m_pAutonomicEnsureNetworkClockAvailabilityThread->Suspend());
    NN_RESULT_SUCCESS;
}

Result StaticService::ResumeAutonomicTimeCorrection() NN_NOEXCEPT
{
    if(!m_pAutonomicEnsureNetworkClockAvailabilityThread)
    {
        NN_RESULT_SUCCESS;
    }

    NN_RESULT_DO(m_pAutonomicEnsureNetworkClockAvailabilityThread->Resume());
    NN_RESULT_SUCCESS;
}

}}}} // nn::ntc::detail::service
