﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/es/es_Types.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentType.h>

namespace nn { namespace ns { namespace srv {

    class IntegratedContentManager;

    Result GetRightsIdIncludingKeyIdList(
        int* outCount, es::RightsIdIncludingKeyId* outList, int listCount,
        const ncm::ContentMetaKey& key, const IntegratedContentManager* pIntegrated, int offset = 0) NN_NOEXCEPT;

    Result GetRightsIdList(
        int* outCount, es::RightsId* outList, int listCount,
        const ncm::ContentMetaKey& key, const IntegratedContentManager* pIntegrated, int offset= 0) NN_NOEXCEPT;

    Result GetRightsIdListLightly(
        int* outCount, es::RightsId* outList, int listCount,
        const ncm::ContentMetaKey& key, const IntegratedContentManager* pIntegrated, int offset = 0) NN_NOEXCEPT;

    bool IsCandidateForExternalKeyContents(ncm::ContentType type) NN_NOEXCEPT;
}}} // ~nn::ns::srv

