﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/srv/ns_PushNotificationDisptcher.h>

namespace nn { namespace ns { namespace srv {

    class NotificationDataReader {
    public:
        NotificationDataReader() NN_NOEXCEPT;
        Result Initialize(const npns::NotificationData& notificationData) NN_NOEXCEPT;

        bool IsSystemUpdateNotification() NN_NOEXCEPT;
        bool IsDownloadTaskListNotification() NN_NOEXCEPT;
        bool IsVersionListNotification() NN_NOEXCEPT;
        bool IsETicketAvailableNotification() NN_NOEXCEPT;
        bool IsSendRightsUsageStatusRequest() NN_NOEXCEPT;
        bool IsSyncELicenseRequest() NN_NOEXCEPT;
        const NotificationInfo& GetNotificationInfo() NN_NOEXCEPT
        {
            NN_SDK_ASSERT(m_Initialized);
            return m_Info;
        }

    private:
        bool m_Initialized;
        NotificationInfo m_Info;
    };
}}}
