﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ns/ns_ApplicationManagerApi.h>

namespace nn { namespace ns { namespace srv {
    bool IsRetryable(Result result) NN_NOEXCEPT;

    bool IsSuspendable(Result result) NN_NOEXCEPT;

    bool IsFatal(Result result) NN_NOEXCEPT;

    bool IsFatalSystemUpdate(Result result) NN_NOEXCEPT;

    bool IsNotEnoughSpace(Result result) NN_NOEXCEPT;

    bool IsResumable(Bit64 attribute) NN_NOEXCEPT;

    ApplicationDownloadState ToState(Bit64 attribute) NN_NOEXCEPT;

    Bit64 ToAttribute(ApplicationDownloadState state) NN_NOEXCEPT;
}}}
