﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ncm/ncm_Result.h>
#include <nn/nim/nim_Result.h>
#include "ns_InstallUtil.h"

namespace nn { namespace ns { namespace srv {
    bool IsRetryable(Result result) NN_NOEXCEPT
    {
        if (   result.IsSuccess()
            || result <= nim::ResultHttpConnectionCanceled()
            || result <= nim::ResultHttpConnectionRetryableTimeout()
            || result <= ncm::ResultInstallTaskCancelled()
            )
        {
            return true;
        }

        return false;
    }

    bool IsSuspendable(Result result) NN_NOEXCEPT
    {
        if (   result <= nim::ResultHttpStatus408RequestTimeout()
            || result <= nim::ResultHttpStatus500InternalServerError()
            || result <= nim::ResultHttpStatus502BadGateway()
            || result <= nim::ResultHttpStatus503ServiceUnavailable()
            || result <= nim::ResultHttpStatus504GatewayTimeout()
            || result <= nim::ResultHttpStatus509BandwidthLimitExceeded()
            || result <= nim::ResultCurlErrorCouldntResolveProxy()
            || result <= nim::ResultCurlErrorCouldntResolveHost()
            || result <= nim::ResultCurlErrorCouldntConnect()
            || result <= nim::ResultCurlErrorRemoteAccessDenied()
            || result <= nim::ResultCurlErrorHttp2()
            || result <= nim::ResultCurlErrorPartialFile()
            || result <= nim::ResultCurlErrorGotNothing()
            || result <= nim::ResultCurlErrorSslConnectError()
            || result <= nim::ResultCurlErrorSendError()
            || result <= nim::ResultCurlErrorRecvError()
            || result <= nim::ResultCurlErrorSendFailRewind()
            || result <= nim::ResultCurlErrorSslShutdownFailed()
            || result <= nim::ResultCurlErrorNoConnectionAvailable()
            || result <= nim::ResultHttpConnectionTimeout()
            || result <= nim::ResultHttpConnectionContentPartialFile()
            )
        {
            return true;
        }

        return false;
    }

    bool IsNotEnoughSpace(Result result) NN_NOEXCEPT
    {
        if (result <= ncm::ResultNotEnoughInstallSpace())
        {
            return true;
        }

        return false;
    }

    bool IsFatal(Result result) NN_NOEXCEPT
    {
        return !IsRetryable(result) && !IsSuspendable(result) && !IsNotEnoughSpace(result);
    }

    bool IsFatalSystemUpdate(Result result) NN_NOEXCEPT
    {
        return !IsRetryable(result) && !IsSuspendable(result);
    }

    bool IsResumable(Bit64 attribute) NN_NOEXCEPT
    {
        auto state = ToState(attribute);
        return (state == ApplicationDownloadState::Suspended ||
                state == ApplicationDownloadState::NotEnoughSpace ||
                state == ApplicationDownloadState::SystemUpdateRequired);
    }

    ApplicationDownloadState ToState(Bit64 attribute) NN_NOEXCEPT
    {
        return static_cast<ApplicationDownloadState>(attribute);
    }

    Bit64 ToAttribute(ApplicationDownloadState state) NN_NOEXCEPT
    {
        return static_cast<Bit64>(state);
    }
}}}
