﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/ec/system/ec_Async.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/srv/ns_OsUtil.h>

#include <nn/util/util_Optional.h>

#include "ns_AsyncImpl.h"
#include "ns_ThreadAllocator.h"

namespace nn { namespace ns { namespace srv {

    class ApplicationRecordDatabase;

    class AsyncCleanupPreInstalledApplicationImpl: public AsyncResultBase, private ErrorContextHolder
    {
    public:
        AsyncCleanupPreInstalledApplicationImpl(ApplicationRecordDatabase* pRecordDb, util::optional<ncm::ApplicationId> id) NN_NOEXCEPT : m_pRecordDb(pRecordDb), m_AppId(id) {}
        virtual ~AsyncCleanupPreInstalledApplicationImpl() NN_NOEXCEPT NN_OVERRIDE;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE;

    private:
        Result Execute() NN_NOEXCEPT;

        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;

        ApplicationRecordDatabase* m_pRecordDb;
        util::optional<ncm::ApplicationId> m_AppId;

        Result m_Result;
        ManualClearSystemEvent m_Event;
        NonRecursiveMutex m_Mutex;
        util::optional<ThreadInfo> m_ThreadInfo;
        util::optional<ec::system::AsyncProgressResult> m_Async;
    };
}}}

