﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/util/util_optional.h>

using namespace nn;

namespace nn { namespace lr {
    class LocationResolver;
}}

namespace nn { namespace lr {
    struct Path;
} }

namespace nn { namespace ns { namespace srv {

Result SearchContentMeta(bool* outValue, lr::Path* outPath, const char* pPath) NN_NOEXCEPT;
Result ReadContentMeta(::std::unique_ptr<Bit8>* outBuffer, size_t* outValue, const char* pPath) NN_NOEXCEPT;
Result LoadHostProgram(ncm::ProgramId* outProgramId, uint8_t* outIndex, util::optional<ncm::ApplicationId>* outApplicationId, uint32_t *outVersion, const char* pPath, lr::LocationResolver* pLocationResolver) NN_NOEXCEPT;

enum ExtensionType
{
    None,
    Nca,
    Nsp,
    Nspd
};

ExtensionType GetExtensionType(const char* fileName) NN_NOEXCEPT;

}}}
