﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/ncm/ncm_InstallTaskOccupiedSize.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationInstallTask
    {
    public:
        typedef ApplicationDownloadProgress TypeProgress;
        typedef ApplicationDownloadState TypeState;

    public:
        explicit ApplicationInstallTask(ncm::ApplicationId appId) NN_NOEXCEPT;

        // IsValid はあくまでも、ApplicationInstallTask を作った時点で
        // タスクが有効かどうか、という判定にしかならない。
        // 自動コミットが働いた場合はタスクが消えてしまうため。
        // タスクがあることを担保したい場合、下記のいずれかの対応が必要。
        // ・RequestServer を止めてから ApplicationInstallTask を作る
        // ・CommitManager のコミットを止めてから ApplicationInstallTask を作る
        // この対応が難しければ、各 API 呼び出しで nim::ResultTaskNotFound をハンドルする必要がある。
        bool IsValid() const NN_NOEXCEPT
        {
            return m_IsValid;
        }

        Result GetProgress(ApplicationDownloadProgress* outValue) NN_NOEXCEPT;

        Result IsDownloaded(bool* outValue) NN_NOEXCEPT;
        Result IsCommittable(bool* outValue, bool checkRequireSystemVersion) NN_NOEXCEPT;
        Result Commit() NN_NOEXCEPT;
        Result CommitPartially(const ncm::StorageContentMetaKey* keys, int count) NN_NOEXCEPT;
        Result ListKey(int* outCount, ncm::StorageContentMetaKey outList[], int count, int offset) NN_NOEXCEPT;
        Result ListCommittedKey(int* outCount, ncm::StorageContentMetaKey outList[], int count, int offset) NN_NOEXCEPT;
        Result ListNotCommittedKey(int* outCount, ncm::StorageContentMetaKey outList[], int count, int offset) NN_NOEXCEPT;
        Result ListKeyFromInstallMeta(int* outCount, ncm::ContentMetaKey outList[], int count, int offset) NN_NOEXCEPT;
        Result NeedsCleanup(bool* outValue) NN_NOEXCEPT;
        Result Destroy() NN_NOEXCEPT;
        Result Resume() NN_NOEXCEPT;
        Result CalculateRequiredSize(int64_t* outValue) NN_NOEXCEPT;
        Result GetRequiredStorage(ncm::StorageId* outValue) NN_NOEXCEPT;
        Result CalculateContentsSize(int64_t* outValue, const ncm::ContentMetaKey& key, ncm::StorageId storageId) NN_NOEXCEPT;
        Result ListOccupiedSize(int* outCount, ncm::InstallTaskOccupiedSize* outList, int numList, int offset) NN_NOEXCEPT;
        Result GetThroughput(int64_t* outValue) NN_NOEXCEPT;
        Result GetErrorContext(err::ErrorContext* outValue) NN_NOEXCEPT;

        Result FindMaxRequiredApplicationVersion(uint32_t* outValue) NN_NOEXCEPT;

        static Result ResumeAll() NN_NOEXCEPT;

    private:
        Result CleanupFragments() NN_NOEXCEPT;

        bool m_IsValid;
        nim::NetworkInstallTaskId m_Id;
    };
}}}

