﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/nsd_ApiForTest.h>

#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/detail/nsd_FqdnResolver.h>
#include <nn/nsd/detail/fs/nsd_Fs.h>
#include <nn/nsd/detail/nsd_Shim.h>

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace nsd {

#if defined(NN_BUILD_CONFIG_OS_WIN)

    namespace
    {
        const char Td1Setting[] = "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJTZXR0aW5nTmFtZSI6InB1YmxpYyBjb25maWcgW3RkMV0gWzIwMTgtMDItMjggMDM6MTU6NTMgVVRDXSIsIkVudmlyb25tZW50IjoidGQxIiwiQmFja2JvbmVTZXR0aW5ncyI6eyJOYXMiOnsiUmVxdWVzdEZxZG4iOiJlMDNhOTc4MTljOTcxMWU1OTUxMGQ4MjBhNTJmMjk4YS1zYi5hY2NvdW50cy5uaW50ZW5kby5jb20iLCJBcGlGcWRuIjoiZTAzYTk3ODE5Yzk3MTFlNTk1MTBkODIwYTUyZjI5OGEtc2ItYXBpLmFjY291bnRzLm5pbnRlbmRvLmNvbSIsIk54QWNjb3VudCI6eyJDbGllbnRJZCI6MTQ1OTg1OTI5OTIwOTAzMjgxNzAsIlJlZGlyZWN0VXJpIjoibmludGVuZG86Ly9hY2NvdW50Lm54LnN5cyJ9LCJOeFNob3AiOnsiQ2xpZW50SWQiOjEzMTIzODk0Nzg5OTkzMzU1NDYzLCJSZWRpcmVjdFVyaSI6Im5pbnRlbmRvOi8vc2hvcC5ueC5zeXMifSwiTnhGcmllbmRzIjp7IkNsaWVudElkIjo2NTE4NDc2MjM4OTEwMTczNzYxLCJSZWRpcmVjdFVyaSI6Im5pbnRlbmRvOi8vZnJpZW5kcy5ueC5zeXMifSwiTnhFTGljZW5zZSI6eyJDbGllbnRJZCI6NTAxOTUwODU2NDg3NzA1NzM5NCwiUmVkaXJlY3RVcmkiOiJuaW50ZW5kbzovL2UtbGljZW5zZS5ueC5zeXMifX0sIkZxZG5FbnRyaWVzIjpbWyJlMGQ2N2M1MDlmYjIwMzg1OGViY2IyZmUzZjg4YzJhYS5iYWFzLm5pbnRlbmRvLmNvbSIsImUwM2E5NzgxOWM5NzExZTU5NTEwZDgyMGE1MmYyOThhLXNiLmJhYXMubmludGVuZG8uY29tIl1dfSwiQXBwbGljYXRpb25TZXR0aW5ncyI6eyJGcWRuRW50cmllcyI6W119LCJFeHBpcmUiOjMyNTAzNjgwMDAwLCJWZXJzaW9uIjoyLCJEZXZpY2VJZCI6IjAifQ.lrd78PgVo28ZnW5Kp0sNldEsAluseprkpduZ4EQMugs3VowekX5mMyM_JeiZ-PAZpZ4lFooat-fGtjt47LCqZpXnUVZUwFF0D7p8Zjx_mYmJ57rP3Wn9JN_HJWeRfAgceKoaVq1oRdokbt1eg2Yk2JYwnZcLt0OdqK1AMmKsdlqAUYlHJ_72LnV0RXZhs7ZoO10T0RvAnbZwY4Uc5bTIlbGm5ff1rxRX_K05GuaXzSfQbbuzGxiCQntT6G0NQ4w4hlTdfxfTgRm05U68kOL5F2L_omVOd728t30lW5WMV32shwW4M7DFEWnjh2vd3ZG3Gel73OMvMqDc1Fee9n4spw";
        // Version: 0x2
        // DeviceId: 0 (1 byte)
        // SettingName: SDK自動テスト td1 [td1] [2018-02-28 03:15:52 UTC] (54 byte, contains non-displayable char)
        // EnvironmentIdentifier: td1 (3 byte)
        // ExpireTime: 0x7915ecc00
        // IsAvailable: true
        // NasServiseSettings: NasRequestServiceFqdn: e03a97819c9711e59510d820a52f298a-sb.accounts.nintendo.com (57 byte)
        // NasServiseSettings: NasApiServiceFqdn: e03a97819c9711e59510d820a52f298a-sb-api.accounts.nintendo.com (61 byte)
        // NasServiseSettings: Entry_0: Name: NxAccount (9 byte),  ClientId: ca989efaca0d0c6a, RedirectUri: nintendo://account.nx.sys (25 byte)
        // NasServiseSettings: Entry_1: Name: NxShop (6 byte),  ClientId: b62170c7332758c7, RedirectUri: nintendo://shop.nx.sys (22 byte)
        // NasServiseSettings: Entry_2: Name: NxFriends (9 byte),  ClientId: 5a76479a5910b241, RedirectUri: nintendo://friends.nx.sys (25 byte)
        // NasServiseSettings: Entry_3: Name: NxELicense (10 byte),  ClientId: 45a8e071fc871d72, RedirectUri: nintendo://e-license.nx.sys (27 byte)
        // NasServiseSettings: Entry_4: Name:  (0 byte),  ClientId: 0, RedirectUri:  (0 byte)
        // NasServiseSettings: Entry_5: Name:  (0 byte),  ClientId: 0, RedirectUri:  (0 byte)
        // NasServiseSettings: Entry_6: Name:  (0 byte),  ClientId: 0, RedirectUri:  (0 byte)
        // NasServiseSettings: Entry_7: Name:  (0 byte),  ClientId: 0, RedirectUri:  (0 byte)
        // BackboneSetting_000: Src: e0d67c509fb203858ebcb2fe3f88c2aa.baas.nintendo.com (50 byte), Dest: e03a97819c9711e59510d820a52f298a-sb.baas.nintendo.com (53 byte)

        nn::nsd::SaveData g_WorkSaveData;
        char g_WorkBuffer[nn::nsd::WorkBufferSizeForImportSettings];

        nn::Result SetTd1EnvironmentForTestImpl() NN_NOEXCEPT
        {
            //
            // TODO:システムセーブデータに書かずに直接キャッシュ更新したい
            //

            NN_RESULT_DO(nn::nsd::ImportSettings(
                Td1Setting,
                sizeof(Td1Setting),
                g_WorkBuffer,
                sizeof(g_WorkBuffer),
                nn::nsd::ImportMode_All));

            // システムセーブデータに入ったデータをキャッシュに持ってくる
            NN_RESULT_DO(nn::nsd::detail::fs::ReadSaveData(&g_WorkSaveData));
            NN_RESULT_DO(nn::nsd::detail::GetFqdnResolverPtr()->SetSaveData(&g_WorkSaveData));

            // 他が(インポート設定の存在しない)デフォルト設定で動作するようにセーブデータ消しとく
            nn::nsd::DeleteSettings(nn::nsd::DeleteMode_All);

            NN_RESULT_SUCCESS;
        }
    }

    void SetTd1EnvironmentForTest() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(SetTd1EnvironmentForTestImpl());
    }

#endif // NN_BUILD_CONFIG_OS_WIN

    void GetCurrentSaveData( SaveData* pSaveData ) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS( nn::nsd::detail::ipc::GetCurrentSetting( pSaveData ) );
    }

    nn::Result DeleteSettingsEx(DeleteMode deleteMode) NN_NOEXCEPT
    {
        return nn::nsd::detail::ipc::DeleteSettings(deleteMode);
    }

    nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT
    {
        NN_RESULT_DO( nn::nsd::detail::ipc::WriteSaveDataToFsForTest(saveData) );
        NN_RESULT_SUCCESS;
    }

    nn::Result ReadSaveDataFromFsForTest(nn::nsd::SaveData* pOut) NN_NOEXCEPT
    {
        NN_RESULT_DO( nn::nsd::detail::ipc::ReadSaveDataFromFsForTest(pOut) );
        NN_RESULT_SUCCESS;
    }

    nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT
    {
       NN_RESULT_DO( nn::nsd::detail::ipc::DeleteSaveDataOfFsForTest() );
       NN_RESULT_SUCCESS;
    }

    void EnableChangeEnvironmentIdentifier() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nsd::detail::ipc::SetChangeEnvironmentIdentifierDisabled(false));
    }

    bool IsChangeEnvironmentIdentifierDisabled() NN_NOEXCEPT
    {
        bool isDisabled;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nsd::detail::ipc::IsChangeEnvironmentIdentifierDisabled(&isDisabled));
        return isDisabled;
    }

}} // nn::nsd
