﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/nsd_Shim.h>
#include <nn/nsd/nsd_ApiForNasService.h>
#include <nn/nsd/nsd_ResultPrivate.h>
#include <nn/nsd/detail/nsd_FqdnResolver.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>
#include <nn/nsd/detail/nsd_Log.h>
#include <nn/nn_Abort.h>

namespace nn { namespace nsd {

    Result GetNasRequestFqdn(Fqdn* pOut) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOut);

        auto result = nn::nsd::detail::ipc::GetNasRequestFqdn( pOut );

        if(result.IsSuccess())
        {
            NN_DETAIL_NSD_INFO_V1("nn::nsd::GetNasRequestFqdn out(%s)\n", pOut->value);
        }
        else
        {
            NN_DETAIL_NSD_ERROR("nn::nsd::GetNasRequestFqdn failed. (%08x, %03d-%04d)\n",
                result.GetInnerValueForDebug(),
                result.GetModule(), result.GetDescription());
        }

        return result;
    }

    void GetNasRequestFqdnEx(Fqdn* pOut) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOut);

        Result innerResult;
        NN_ABORT_UNLESS_RESULT_SUCCESS( nn::nsd::detail::ipc::GetNasRequestFqdnEx( &innerResult, pOut ) );

        if(innerResult.IsFailure())
        {
            NN_DETAIL_NSD_WARN("nn::nsd::GetNasRequestFqdnEx outputs invalid FQDN. Inner error(%08x, %03d-%04d)\n",
                innerResult.GetInnerValueForDebug(),
                innerResult.GetModule(), innerResult.GetDescription());
        }

        NN_DETAIL_NSD_INFO_V1("nn::nsd::GetNasRequestFqdnEx out(%s)\n", pOut->value);
    }

    Result GetNasApiFqdn(Fqdn* pOut) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOut);

        auto result = nn::nsd::detail::ipc::GetNasApiFqdn( pOut );

        if(result.IsSuccess())
        {
            NN_DETAIL_NSD_INFO_V1("nn::nsd::GetNasApiFqdn out(%s)\n", pOut->value);
        }
        else
        {
            NN_DETAIL_NSD_ERROR("nn::nsd::GetNasApiFqdn failed. (%08x, %03d-%04d)\n",
                result.GetInnerValueForDebug(),
                result.GetModule(), result.GetDescription());
        }

        return result;
    }

    void GetNasApiFqdnEx(Fqdn* pOut) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOut);

        Result innerResult;
        NN_ABORT_UNLESS_RESULT_SUCCESS( nn::nsd::detail::ipc::GetNasApiFqdnEx( &innerResult, pOut ) );

        if(innerResult.IsFailure())
        {
            NN_DETAIL_NSD_WARN("nn::nsd::GetNasApiFqdnEx outputs invalid FQDN. Inner error(%08x, %03d-%04d)\n",
                innerResult.GetInnerValueForDebug(),
                innerResult.GetModule(), innerResult.GetDescription());
        }

        NN_DETAIL_NSD_INFO_V1("nn::nsd::GetNasApiFqdnEx out(%s)\n", pOut->value);
    }

    Result GetNasServiceSetting(
        NasServiceSetting* pOutNasServiceSetting,
        const NasServiceName& nasServiceName) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutNasServiceSetting);

        auto result = nn::nsd::detail::ipc::GetNasServiceSetting(pOutNasServiceSetting, nasServiceName);

        if(result.IsSuccess())
        {
            NN_DETAIL_NSD_INFO_V1("nn::nsd::GetNasServiceSetting ClientId(%016llx) RedirectUri(%s)\n",
                pOutNasServiceSetting->clientId,
                pOutNasServiceSetting->redirectUri.value);
        }
        else
        {
            NN_DETAIL_NSD_ERROR("nn::nsd::GetNasServiceSetting failed. (%08x, %03d-%04d)\n",
                result.GetInnerValueForDebug(),
                result.GetModule(), result.GetDescription());
        }

        return result;
    }

    void GetNasServiceSettingEx(
        NasServiceSetting* pOutNasServiceSetting,
        const NasServiceName& nasServiceName) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutNasServiceSetting);

        Result innerResult;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nsd::detail::ipc::GetNasServiceSettingEx(&innerResult, pOutNasServiceSetting,nasServiceName) );

        if(innerResult.IsFailure())
        {
            NN_DETAIL_NSD_WARN("nn::nsd::GetNasServiceSettingEx failed. Inner error(%08x, %03d-%04d)\n",
                       innerResult.GetInnerValueForDebug(),
                       innerResult.GetModule(), innerResult.GetDescription());
        }

        NN_DETAIL_NSD_INFO_V1("nn::nsd::GetNasServiceSettingEx ClientId(%016llx) RedirectUri(%s)\n",
            pOutNasServiceSetting->clientId,
            pOutNasServiceSetting->redirectUri.value);
    }

}} // nn::nsd
