﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/util/nsd_StringUtility.h>

namespace nn { namespace nsd { namespace detail { namespace util {

    /*
     * @brief   begin から end の直前まで検索し c と一致するポインタを返す. NULL 終端が見つかった時点で検索終了.
     * @param[in]   begin   検索開始のポインタ
     * @param[in]   end     検索終了のポインタ(end 直前のポインタまで検索)
     * @param[in]   c       検索対象の文字
     *
     * @return 検索ヒットした要素を指すポインタ
     * @retval nullptr        見つからなかった
     * @retval nullptr以外    見つかった
     */
    const char* SearchCharWithEndPtr(const char* begin, const char* end, char c) NN_NOEXCEPT
    {
        if(begin == nullptr || end == nullptr || begin >= end)
        {
            return nullptr;
        }

        const char *p = begin;
        int count = 0;
        while( *p != '\0' && p < end)
        {
            if(*p == c)
            {
                return p;
            }
            p++;
            count++;
        }

        return nullptr;
    }

    /*
     * @brief   src 中の c のポインタを返す
     * @param[in]   src     検索をかけたい文字列
     * @param[in]   length  文字列の長さ
     * @param[in]   c       検索対象の文字
     *
     * @return 検索ヒットした src の要素を指すポインタ
     * @retval nullptr        見つからなかった
     * @retval nullptr以外    見つかった
     */
    const char* SearchCharWithLenght(const char* src, int length, char c) NN_NOEXCEPT
    {
        if(src == nullptr || length <= 0)
        {
            return nullptr;
        }

        const char *p = src;

        int count = 0;
        while( *p != '\0' && count < length)
        {
            if(*p == c)
            {
                return p;
            }
            p++;
            count++;
        }

        return nullptr;
    }

}}}} // nn::nsd::detail::util
