﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_SystemContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct SystemUpdateId{}

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(16, 8)]
    public struct ContentMetaKey{}
}

namespace nn.ns.detail
{
    [CppRefPath("<nn/ns/detail/ns_IVulnerabilityManagerInterface.sfdl.h>")]
    public interface IVulnerabilityManagerInterface : IServiceObject
    {
        // Vulnerability API
        // - MethodId: 1200 - 1299
        [MethodId(1200)]
        Result NeedsUpdateVulnerability(Out<bool> outValue);

        // デバッグ用:
        [MethodId(1201)]
        Result UpdateSafeSystemVersionForDebug(nn.ncm.SystemUpdateId systemUpdateId, uint32_t version);

        [MethodId(1202)]
        Result GetSafeSystemVersion(Out<nn.ncm.ContentMetaKey> outValue);
    }
}
