﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>
#include <nn/ns/detail/ns_IVulnerabilityManagerInterface.sfdl.h>
#include <nn/ns/detail/ns_ISystemUpdateInterface.sfdl.h>

#include "ns_ServiceObjectHolder.h"

namespace nn { namespace ns {
    void InitializeServiceObjects(bool abortIfApplicationManagerInitializeFailed) NN_NOEXCEPT;
    void FinalizeServiceObjects() NN_NOEXCEPT;

    detail::IVulnerabilityManagerInterface* GetVulnerabilityManagerInterface() NN_NOEXCEPT;
    detail::ISystemUpdateInterface* GetSystemUpdateInterfaceInterface() NN_NOEXCEPT;

    sf::SharedPointer<detail::IApplicationManagerInterface> GetApplicationManagerInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IDocumentInterface> GetDocumentInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IContentManagementInterface> GetContentManagementInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IDownloadTaskInterface> GetDownloadTaskInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IAccountProxyInterface> GetAccountProxyInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IFactoryResetInterface> GetFactoryResetInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IApplicationVersionInterface> GetApplicationVersionInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IECommerceInterface> GetECommerceInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IReadOnlyApplicationRecordInterface> GetReadOnlyApplicationRecordInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IReadOnlyApplicationControlDataInterface> GetReadOnlyApplicationControlDataInterface() NN_NOEXCEPT;
    sf::SharedPointer<detail::IDynamicRightsInterface> GetDynamicRightsInterface() NN_NOEXCEPT;

    struct ServiceObjectHolders
    {
        ServiceObjectHolder<detail::IVulnerabilityManagerInterface> vulnerabilityManagerInterfaceHolder;
        ServiceObjectHolder<detail::ISystemUpdateInterface> systemUpdateInterfaceHolder;
        ServiceObjectHolder<detail::IServiceGetterInterface> serviceGetterInterfaceHolder;
    };

    void InitializeServiceObjectsImpl(bool abortIfApplicationManagerInitializeFailed, ServiceObjectHolders* holders) NN_NOEXCEPT;
    void FinalizeServiceObjectsImpl(ServiceObjectHolders* holders) NN_NOEXCEPT;

    void InitializeMemoryResourceImpl() NN_NOEXCEPT;
    void FinalizeMemoryResourceImpl() NN_NOEXCEPT;
}}
