﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    public struct ProcessId
    {
        public nn.Bit64 value;
    }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_ProgramLocation.h>")]
    [ExternalStruct(16, 8)]
    public struct ProgramLocation
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 1)]
    public struct StorageId{}
}

namespace nn.ns
{
    [CppRefPath(@"<nn/ns/ns_DevelopApi.h>")]
    public struct ShellEventInfo
    {
        public int32_t              event_;
        public nn.os.ProcessId      processId;
    }

    [CppRefPath(@"<nn/ns/ns_DevelopApi.h>")]
    [ExternalStruct(16, 8)]
    public struct ProgramLaunchProperty
    {
    }

    [CppRefPath(@"<nn/ns/ns_ApplicationLaunchInfo.h>")]
    [ExternalStruct(64, 8)]
    public struct ApplicationLaunchInfo
    {
    }
}

namespace nn.arp
{
    [CppRefPath(@"<nn/arp/arp_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct ApplicationLaunchProperty
    {
    }
}

namespace nn.ns.detail
{
    public interface IDevelopInterface : IServiceObject
    {
        [MethodId(0)]
        Result
            LaunchProgram(
                Out<nn.os.ProcessId>        pOut,
                nn.ns.ProgramLaunchProperty launchProperty,
                int32_t                     flags
            );

        [MethodId(1)]
        Result
            TerminateProcess(
                nn.os.ProcessId         id
            );

        [MethodId(2)]
        Result
            TerminateProgram(
                nn.ncm.ProgramId         id
            );

        [MethodId(4)]
        Result
            GetShellEventHandle(
                Out<NativeHandle>       handle
            );

        [MethodId(5)]
        Result
            GetShellEventInfo(
                Out<nn.ns.ShellEventInfo>   pOut
            );

        [MethodId(6)]
        Result
            TerminateApplication(
            );

        [MethodId(7)]
        Result
            PrepareLaunchProgramFromHost(
                Out<nn.ns.ProgramLaunchProperty>    launchProperty,
                InBuffer                            programPath
            );

        [MethodId(8)]
        Result
            LaunchApplication(
                Out<nn.os.ProcessId>    pOut,
                nn.ncm.ApplicationId    applicationId,
                int32_t                 flags
            );

        [MethodId(9)]
        Result
            LaunchApplicationWithStorageId(
                Out<nn.os.ProcessId>    pOut,
                nn.ncm.ApplicationId    applicationId,
                int32_t                 flags,
                nn.ncm.StorageId        appStorageId,
                nn.ncm.StorageId        patchStorageId
            );

        [MethodId(10)]
        Result
            IsSystemMemoryResourceLimitBoosted(
                Out<bool> pOut
            );

        [MethodId(11)]
        Result
            GetRunningApplicationProcessId(
                Out<nn.os.ProcessId>    pOut
            );

    }
}

