﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/ns/ns_ApplicationRightsApi.h>
#include <nn/ns/ns_ApplicationRightsSystemApi.h>
#include <nn/ns/ns_Result.h>

#include "ns_Initialize.h"

namespace nn { namespace ns {
    //--------------------------------------------------------------------------
    //  Application Rights API
    //--------------------------------------------------------------------------
    Result GetApplicationRightsOnClient(
        int* outCount,
        ApplicationRightsOnClient* outList,
        int listCount,
        ncm::ApplicationId appId) NN_NOEXCEPT
    {
        return GetApplicationRightsOnClient(outCount, outList, listCount, appId, account::InvalidUid);
    }

    Result GetApplicationRightsOnClient(
        int* outCount,
        ApplicationRightsOnClient* outList,
        int listCount,
        ncm::ApplicationId appId,
        const account::Uid& uid) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetApplicationRightsOnClient(outCount, sf::OutArray<ApplicationRightsOnClient>(outList, listCount), appId, uid, ApplicationRightsOnClientQueryFlag_AllContents);
    }

    Result GetApplicationRightsOnClientForApplication(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId) NN_NOEXCEPT
    {
        return GetApplicationRightsOnClientForApplication(outValue, appId, account::InvalidUid);
    }

    Result GetApplicationRightsOnClientForApplication(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId,
        const account::Uid& uid) NN_NOEXCEPT
    {
        int tmpCount;
        return GetApplicationManagerInterface()->GetApplicationRightsOnClient(&tmpCount, sf::OutArray<ApplicationRightsOnClient>(outValue, 1), appId, uid, ApplicationRightsOnClientQueryFlag_Application::Mask);
    }

    Result GetApplicationRightsOnClientForAddOnContent(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId) NN_NOEXCEPT
    {
        return GetApplicationRightsOnClientForAddOnContent(outValue, appId, account::InvalidUid);
    }

    Result GetApplicationRightsOnClientForAddOnContent(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId,
        const account::Uid& uid) NN_NOEXCEPT
    {
        int tmpCount;
        return GetApplicationManagerInterface()->GetApplicationRightsOnClient(&tmpCount, sf::OutArray<ApplicationRightsOnClient>(outValue, 1), appId, uid, ApplicationRightsOnClientQueryFlag_AddOnContent::Mask);
    }


    //--------------------------------------------------------------------------
    //  ApplicationRightsOnClient
    //--------------------------------------------------------------------------

    bool ApplicationRightsOnClient::HasAvailableRights() const NN_NOEXCEPT
    {
        return _flags.Test<ApplicationRightsOnClientFlag_HasAvailableRights>();
    }

    bool ApplicationRightsOnClient::HasUnavailableRights() const NN_NOEXCEPT
    {
        return _flags.Test<ApplicationRightsOnClientFlag_HasUnavailableRights>();
    }

    bool ApplicationRightsOnClient::HasAccountRestrictedRights() const NN_NOEXCEPT
    {
        return _flags.Test<ApplicationRightsOnClientFlag_HasAccountRestrictedRights>();
    }

    bool ApplicationRightsOnClient::HasPrepurchasedRights() const NN_NOEXCEPT
    {
        return _flags.Test<ApplicationRightsOnClientFlag_HasPrepurchasedRights>();
    }

    bool ApplicationRightsOnClient::RecommendInquireServer() const NN_NOEXCEPT
    {
        return _flags.Test<ApplicationRightsOnClientFlag_RecommendInquireServer>();
    }

}}
