﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

[AttributeUsage(AttributeTargets.Struct | AttributeTargets.Parameter, AllowMultiple = true)]
class NonNegativeAttribute : PreAttribute
{
    public NonNegativeAttribute() : base("_ >= 0")  { }
}

namespace nn.account
{
    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/account/account_Types.h>")]
    public struct Uid
    {
    }

    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(33, 1)]
    public struct Nickname
    {
    }

}

namespace nn.es
{
    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct AccountId
    {
    }
}

namespace nn.fs
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/fs/fs_SaveDataTypes.h>")]
    public struct SystemSaveDataId
    {
    }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId{}

    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId{}

    [CppRefPath(@"<nn/ncm/ncm_SystemContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct SystemProgramId{}

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(16, 8)]
    public struct ContentMetaKey{}

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(24, 8)]
    public struct StorageContentMetaKey { }

    [CppRefPath(@"<nn/ncm/ncm_ContentType.h>")]
    [ExternalStruct(1, 1)]
    public struct ContentType{}

    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 1)]
    public struct StorageId{}

    [CppRefPath(@"<nn/ncm/ncm_ContentStorage.h>")]
    [ExternalStruct(768, 4)]
    [LargeData(true)]
    public struct Path{}
}

namespace nn.ns
{
    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(1, 1)]
    public struct ApplicationEvent { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(24, 8)]
    public struct ApplicationRecord { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(64, 8)]
    public struct ApplicationViewDeprecated { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(80, 8)]
    public struct ApplicationView { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(128, 8)]
    public struct ApplicationOccupiedSize { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(1, 1)]
    public struct ApplicationControlSource { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(16, 8)]
    public struct GameCardAttachmentInfo { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerApi.h>")]
    [ExternalStruct(32, 8)]
    public struct SystemVersionSignage { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerSystemApi.h>")]
    [ExternalStruct(1, 1)]
    public struct ApplicationUpdateConfig { }

    [CppRefPath(@"<nn/ns/ns_ApplicationManagerSystemApi.h>")]
    [ExternalStruct(16, 8)]
    public struct ApplicationShellEventInfo { }

    [CppRefPath(@"<nn/ns/ns_ApplicationVersionSystemApi.h>")]
    [ExternalStruct(16, 8)]
    public struct RequiredVersionEntry { }

    [CppRefPath(@"<nn/ns/ns_ApplicationVersionSystemApi.h>")]
    [ExternalStruct(16, 8)]
    public struct VersionListEntry { }

    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/ns/ns_UserResourceManagementApi.h>")]
    public struct UserSaveDataStatistics { }

    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/ns/ns_GameCardRegistrationApi.h>")]
    public struct GameCardRegistrationStatus { }

    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/ns/ns_ApplicationContentMetaApi.h>")]
    public struct ApplicationContentMetaStatus { }

    [ExternalStruct(512, 8)]
    [CppRefPath("<nn/ns/ns_ApplicationRecordSystemApi.h>")]
    [LargeData(true)]
    public struct ApplicationRecordProperty { }

    [ExternalStruct(32, 1)]
    [CppRefPath("<nn/ns/ns_PseudoDeviceIdApi.h>")]
    public struct SystemSeedForPseudoDeviceId { }

    [ExternalStruct(32, 8)]
    [CppRefPath("<nn/ns/ns_DownloadTaskSystemApi.h>")]
    public struct DownloadTaskStatus { }

    [ExternalStruct(32, 8)]
    [CppRefPath("<nn/ns/ns_ApplicationControlDataSystemApi.h>")]
    public struct ApplicationControlCacheEntryInfo { }

    [ExternalStruct(136, 8)]
    [CppRefPath("<nn/ns/ns_NotificationSystemApi.h>")]
    public struct NotificationInfo { }

    [ExternalStruct(168, 8)]
    [CppRefPath("<nn/ns/ns_NotificationSystemApi.h>")]
    public struct AsyncTask { }

    [CppRefPath(@"<nn/ns/ns_RetailInteractiveDisplayApi.h>")]
    [ExternalStruct(1, 1)]
    public struct ApplicationDownloadTaskStatus { }

    [CppRefPath(@"<nn/ns/ns_ApplicationDeliveryInfo.h>")]
    [ExternalStruct(256, 8)]
    public struct ApplicationDeliveryInfo { }

    [ExternalStruct(32, 1)]
    public struct ApplicationDeliveryInfoHash { }

    [CppRefPath(@"<nn/ns/ns_ApplicationDeliveryInfo.h>")]
    [ExternalStruct(4, 4)]
    public struct ApplicationDeliveryAttribute { }

    [CppRefPath(@"<nn/ns/ns_SystemDeliveryInfo.h>")]
    [ExternalStruct(256, 8)]
    [LargeData(true)]
    public struct SystemDeliveryInfo { }

    [CppRefPath(@"<nn/ns/ns_ContentDeliveryProgress.h>")]
    [ExternalStruct(16, 8)]
    public struct ReceiveApplicationProgress { }

    [CppRefPath(@"<nn/ns/ns_ContentDeliveryProgress.h>")]
    [ExternalStruct(16, 8)]
    public struct SendApplicationProgress { }

    [CppRefPath(@"<nn/ns/ns_TicketApi.h>")]
    [ExternalStruct(8, 1)]
    public struct ApplicationTicketInfo { }

    [CppRefPath(@"<nn/ns/ns_ApplicationLaunchInfo.h>")]
    [ExternalStruct(64, 8)]
    public struct ApplicationLaunchInfo { }

    [CppRefPath(@"<nn/ns/ns_ApplicationControlDataApi.h>")]
    [ExternalStruct(16384, 8)]
    [LargeData(true)]
    public struct ApplicationControlProperty { }

    [CppRefPath(@"<nn/ns/ns_ApplicationRightsTypes.h>")]
    [ExternalStruct(40, 8)]
    public struct ApplicationRightsOnServer { }

    [CppRefPath(@"<nn/ns/ns_ApplicationRightsTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct ApplicationRightsOnClient { }

    [CppRefPath(@"<nn/ns/ns_ApplicationRightsSystemApi.h>")]
    [ExternalStruct(4, 4)]
    public struct ApplicationRightsOnClientQueryFlag { }

    [CppRefPath(@"<nn/ns/ns_ApplicationRightsTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct RightsEnvironmentHandle { }

    [CppRefPath(@"<nn/ns/ns_ApplicationRightsTypes.h>")]
    [ExternalStruct(16, 8)]
    public struct RightsEnvironmentStatus { }

    [CppRefPath(@"<nn/ns/ns_ApplicationCopyIdentifierTypes.h>")]
    [ExternalStruct(528, 8)]
    [LargeData(true)]
    public struct GameCardApplicationCopyIdentifier { }

    [CppRefPath(@"<nn/ns/ns_ApplicationCopyIdentifierTypes.h>")]
    [ExternalStruct(1312, 8)]
    [LargeData(true)]
    public struct InstalledApplicationCopyIdentifier { }

    [CppRefPath(@"<nn/ns/ns_ApplicationRightsTypes.h>")]
    [ExternalStruct(1, 1)]
    public struct ApplicationRightsStatus { }
}

namespace nn.ns.detail
{
    [ExternalStruct(40, 8)]
    [CppRefPath("<nn/ns/detail/ns_UserResourceManagementInternalTypes.h>")]
    public struct ProgressForDeleteUserSaveDataAll
    {
    }
}

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct ProcessId {}
}

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 8)]
    public struct LanguageCode{}
}

namespace nn.nim
{
    [CppRefPath(@"<nn/nim/nim_BackgroundDownloadStressTaskInfo.h>")]
    [ExternalStruct(16, 8)]
    public struct BackgroundDownloadStressTaskInfo{}
}

namespace nn.ns.detail
{
    // フルセットのアプリケーション管理用のインターフェースです。
    //
    // 機能毎のインターフェースに分割されて、このインターフェースが消滅するのが最終形ですが
    // システム側のポート数の上限や、利用者毎に割り当てる必要の整理が不十分なことから
    // 現在はこの状態で残されています。
    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IApplicationManagerInterface : IServiceObject
    {
        [MethodId(11)]
        Result CalculateApplicationOccupiedSize(Out<ApplicationOccupiedSize> outValue, nn.ncm.ApplicationId id);

        // [MethodId(19)]
        // Result DeprecatedLaunchApplication(Out<os.ProcessId> outValue, nn.ncm.ApplicationId id);

        [MethodId(21)]
        Result GetApplicationContentPath([BufferTransferMode(BufferTransferMode.MapAlias)] Out<nn.ncm.Path> outValue, nn.ncm.ApplicationId id, nn.ncm.ContentType type);

        [MethodId(22)]
        Result TerminateApplication(os.ProcessId pid);

        [MethodId(23)]
        Result ResolveApplicationContentPath(nn.ncm.ProgramId id, nn.ncm.ContentType type);

        [MethodId(26)]
        Result BeginInstallApplication(nn.ncm.ApplicationId id, uint32_t version, ncm.StorageId storageId);

        [MethodId(30)]
        Result RequestApplicationUpdateInfo(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, ncm.ApplicationId id);

        // INFO: RequestUpdateApplication2 へ移行している。
        //[MethodId(31)]
        //Result RequestUpdateApplication(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ncm.ApplicationId id, ApplicationUpdateConfig config);

        [MethodId(32)]
        Result CancelApplicationDownload(ncm.ApplicationId id);

        [MethodId(33)]
        Result ResumeApplicationDownload(ncm.ApplicationId id);

        [MethodId(38)]
        Result CheckApplicationLaunchVersion(nn.ncm.ApplicationId id);

        [MethodId(39)]
        Result CheckApplicationLaunchRights(nn.ncm.ApplicationId id);

        [MethodId(40)]
        Result GetApplicationLogoData(Out<int64_t> outSize, [BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer outBuffer, nn.ncm.ApplicationId id, [BufferTransferMode(BufferTransferMode.MapAlias)] nn.ncm.Path logoPath);

        [MethodId(41)]
        Result CalculateApplicationDownloadRequiredSize(Out<nn.ncm.StorageId> outStorage, Out<int64_t> outValue, nn.ncm.ApplicationId id);

        [MethodId(45)]
        Result GetGameCardAttachmentEvent(Out<NativeHandle> outValue);

        [MethodId(46)]
        Result GetGameCardAttachmentInfo(Out<nn.ns.GameCardAttachmentInfo> outValue);

        [MethodId(47)]
        Result GetTotalSpaceSize(Out<int64_t> outSize, nn.ncm.StorageId storage);

        [MethodId(48)]
        Result GetFreeSpaceSize(Out<int64_t> outSize, nn.ncm.StorageId storage);

        [MethodId(52)]
        Result GetGameCardUpdateDetectionEvent(Out<NativeHandle> outValue);

        [MethodId(53)]
        Result DisableApplicationAutoDelete(nn.ncm.ApplicationId id);

        [MethodId(54)]
        Result EnableApplicationAutoDelete(nn.ncm.ApplicationId id);

        // IReadOnlyApplicationControlDataInterface に移行しました。
        // [MethodId(55)]
        // Result GetApplicationDesiredLanguage(Out<nn.Bit8> outValue, nn.Bit32 supportedLanguageFlag);

        [MethodId(56)]
        Result SetApplicationTerminateResult(nn.ncm.ApplicationId id, uint32_t result);

        [MethodId(57)]
        Result ClearApplicationTerminateResult(nn.ncm.ApplicationId id);

        // IReadOnlyApplicationControlDataInterface に移行しました。
        // [MethodId(59)]
        // Result ConvertApplicationLanguageToLanguageCode(Out<nn.settings.LanguageCode> outValue, nn.Bit8 language);

        // IReadOnlyApplicationControlDataInterface に移行しました。
        // [MethodId(60)]
        // Result ConvertLanguageCodeToApplicationLanguage(Out<nn.Bit8> outValue, nn.settings.LanguageCode code);

        [MethodId(61)]
        Result GetBackgroundDownloadStressTaskInfo(Out<nn.nim.BackgroundDownloadStressTaskInfo> outValue);

        [MethodId(62)]
        Result GetGameCardStopper(Out<IGameCardStopper> outValue);

        [MethodId(63)]
        Result IsSystemProgramInstalled(Out<bool> outValue, nn.ncm.SystemProgramId id);

        [MethodId(64)]
        Result StartApplyDeltaTask(nn.ncm.ApplicationId id);

        [MethodId(65)]
        Result GetRequestServerStopper(Out<IRequestServerStopper> outValue);

        [MethodId(66)]
        Result GetBackgroundApplyDeltaStressTaskInfo(Out<nn.nim.BackgroundDownloadStressTaskInfo> outValue);

        [MethodId(67)]
        Result CancelApplicationApplyDelta(ncm.ApplicationId id);

        [MethodId(68)]
        Result ResumeApplicationApplyDelta(ncm.ApplicationId id);

        [MethodId(69)]
        Result CalculateApplicationApplyDeltaRequiredSize(Out<nn.ncm.StorageId> outStorage, Out<int64_t> outValue, nn.ncm.ApplicationId id);

        [MethodId(70)]
        Result ResumeAll();

        [MethodId(71)]
        Result GetStorageSize(Out<int64_t> outTotalSize, Out<int64_t> outFreeSize, nn.ncm.StorageId storage);

        [MethodId(80)]
        Result RequestDownloadApplication(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ncm.ApplicationId applicationId, ncm.StorageId storageId, bool forceDirectUpdate);

        [MethodId(81)]
        Result RequestDownloadAddOnContent(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ncm.ApplicationId id, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.StorageId storageId);

        [MethodId(82)]
        Result DownloadApplication(ncm.ApplicationId applicationId, ncm.StorageId storageId, bool forceDirectUpdate);

        [MethodId(83)]
        Result CheckApplicationResumeRights(nn.ncm.ApplicationId id);

        [MethodId(84)]
        Result GetDynamicCommitEvent(Out<NativeHandle> outHandle);

        [MethodId(85)]
        Result RequestUpdateApplication2(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ncm.ApplicationId id);

        [MethodId(86)]
        void EnableApplicationCrashReport(bool isEnable);

        [MethodId(87)]
        bool IsApplicationCrashReportEnabled();

        [MethodId(90)]
        Result BoostSystemMemoryResourceLimit(int64_t boostSize);

        // INFO: 下位互換のためしばらくの間残しておく
        [MethodId(91)]
        Result DeprecatedLaunchApplication(Out<os.ProcessId> outValue, ncm.ApplicationId id, uint8_t programIndex);

        [MethodId(92)]
        Result GetRunningApplicationProgramId(Out<ncm.ProgramId> outValue, ncm.ApplicationId id);

        [MethodId(93)]
        Result GetMainApplicationProgramIndex(Out<uint8_t> outValue, ncm.ApplicationId id);

        [MethodId(94)]
        Result LaunchApplication(Out<os.ProcessId> outValue, ApplicationLaunchInfo info, uint8_t programIndex);

        [MethodId(95)]
        Result GetApplicationLaunchInfo(Out<ApplicationLaunchInfo> outValue, ncm.ApplicationId id);

        [MethodId(96)]
        Result AcquireApplicationLaunchInfo(Out<ApplicationLaunchInfo> outValue, os.ProcessId processId);

        [MethodId(97)]
        Result GetMainApplicationProgramIndexByApplicationLaunchInfo(Out<uint8_t> outValue, ApplicationLaunchInfo info);

        [MethodId(98)]
        void EnableApplicationAllThreadDumpOnCrash(bool isEnabled);

        // FactoryReset API
        //  - MethodId: 100 - 200
        [MethodId(100)]
        Result ResetToFactorySettings();

        [MethodId(101)]
        Result ResetToFactorySettingsWithoutUserSaveData();

        [MethodId(102)]
        Result ResetToFactorySettingsForRefurbishment();
        // ~FactoryReset API

        // UserResourceManagement API
        //  - MethodId: 200 - 299
        [MethodId(200)]
        Result CalculateUserSaveDataStatistics(sf.Out<UserSaveDataStatistics> pOut, account.Uid uid);

        [MethodId(201)]
        Result DeleteUserSaveDataAll(sf.Out<IProgressMonitorForDeleteUserSaveDataAll> pOut, account.Uid uid);

        [MethodId(210)]
        Result DeleteUserSystemSaveData(account.Uid uid, fs.SystemSaveDataId sysSaveId);

        [MethodId(220)]
        Result UnregisterNetworkServiceAccount(account.Uid uid);

        [MethodId(221)]
        Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(account.Uid uid);
        // ~UserResourceManagement API

        // AppletLauncher API
        //  - MethodId: 300 - 399
        [MethodId(300)]
        Result GetApplicationShellEvent(Out<NativeHandle> outValue);

        [MethodId(301)]
        Result PopApplicationShellEventInfo(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationShellEventInfo> outList);

        [MethodId(302)]
        Result LaunchLibraryApplet(Out<os.ProcessId> outValue, nn.ncm.SystemProgramId id);

        [MethodId(303)]
        Result TerminateLibraryApplet(os.ProcessId pid);

        [MethodId(304)]
        Result LaunchSystemApplet(Out<os.ProcessId> outValue);

        [MethodId(305)]
        Result TerminateSystemApplet(os.ProcessId pid);

        [MethodId(306)]
        Result LaunchOverlayApplet(Out<os.ProcessId> outValue);

        [MethodId(307)]
        Result TerminateOverlayApplet(os.ProcessId pid);
        // ~AppletLauncher API

        // ApplicationControlData API
        //  - MethodId: 400 - 499
        // IReadOnlyApplicationControlDataInterface に移行しました。
        // [MethodId(400)]
        // Result GetApplicationControlData(Out<uint32_t> outValue, OutBuffer buffer, ApplicationControlSource source, nn.ncm.ApplicationId id);

        [MethodId(401)]
        Result InvalidateAllApplicationControlCache();

        [MethodId(402)]
        Result RequestDownloadApplicationControlData(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ncm.ApplicationId id);

        [MethodId(403)]
        Result GetMaxApplicationControlCacheCount(Out<int> outValue);

        [MethodId(404)]
        Result InvalidateApplicationControlCache(nn.ncm.ApplicationId id);

        [MethodId(405)]
        Result ListApplicationControlCacheEntryInfo(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationControlCacheEntryInfo> outList);

        [MethodId(406)]
        Result GetApplicationControlProperty([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ApplicationControlProperty> outValue, ApplicationLaunchInfo info, uint8_t programIndex);

        // GameCardRegistration API
        //  - MethodId: 500 - 599
        // インターフェース変更により廃止
        //        [MethodId(500)] // INFO: Ocean 互換性のため 1.1.0ss1 までは残す
        //        Result RequestGameCardRegistrationStatus(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, nn.account.Uid uid, nn.ncm.ApplicationId appId);

        //        [MethodId(501)] // INFO: Ocean 互換性のため 1.1.0ss1 までは残す
        //        Result RequestRegisterGameCard(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.Uid uid, nn.ncm.ApplicationId appId, GameCardRegistrationStatus status);

        [MethodId(502)]
        Result RequestCheckGameCardRegistration(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.ncm.ApplicationId appId);

        [MethodId(503)]
        Result RequestGameCardRegistrationGoldPoint(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, nn.account.Uid uid, nn.ncm.ApplicationId appId);

        [MethodId(504)]
        Result RequestRegisterGameCard(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.Uid uid, nn.ncm.ApplicationId appId, int goldPoint);

        [MethodId(505)]
        Result GetGameCardMountFailureEvent(Out<NativeHandle> outHandle);

        [MethodId(506)]
        Result IsGameCardInserted(Out<bool> outValue);

        [MethodId(507)]
        Result EnsureGameCardAccess();

        [MethodId(508)]
        Result GetLastGameCardMountFailureResult();

        [MethodId(509)]
        Result ListApplicationIdOnGameCard(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.ApplicationId> outList);

        // ApplicationContentMeta API
        //  - MethodId: 600 - 699
        [MethodId(600)]
        Result CountApplicationContentMeta(Out<int> outValue, nn.ncm.ApplicationId appId);

        [MethodId(601)]
        Result ListApplicationContentMetaStatus(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationContentMetaStatus> outList, nn.ncm.ApplicationId appId, [NonNegative] int offset);

        [MethodId(602)]
        Result ListAvailableAddOnContent(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationContentMetaStatus> outList, nn.ncm.ApplicationId appId, [NonNegative] int offset);

        [MethodId(603)]
        Result GetOwnedApplicationContentMetaStatus(Out<nn.ns.ApplicationContentMetaStatus> outValue, nn.ncm.ApplicationId appId, nn.Bit64 contentMetaId);

        [MethodId(604)]
        Result RegisterContentsExternalKey(nn.ncm.ApplicationId appId, nn.Bit64 contentMetaId);

        [MethodId(605)]
        Result ListApplicationContentMetaStatusWithRightsCheck(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationContentMetaStatus> outList, nn.ncm.ApplicationId appId, [NonNegative] int offset);

        [MethodId(606)]
        Result GetContentMetaStorage(Out<nn.ncm.StorageId> outValue, nn.ncm.ContentMetaKey key);

        // DownloadTask API
        //  - MethodId: 700 - 799
        [MethodId(700)]
        Result PushDownloadTaskList([BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer buffer);

        [MethodId(701)]
        Result ClearTaskStatusList();

        [MethodId(702)]
        Result RequestDownloadTaskList();

        [MethodId(703)]
        Result RequestEnsureDownloadTask(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(704)]
        Result ListDownloadTaskStatus(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<DownloadTaskStatus> outList);

        [MethodId(705)]
        Result RequestDownloadTaskListData(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        // ApplicationVersion API
        // - MethodId: 800 - 899
        //
        // TODO: IApplicationVersionInterface に移動済みだが互換性のため残している。4 系での Ocean のリビルドが済むぐらいのタイミングで削除すること(SIGLO-63957)
        [MethodId(35)]
        Result UpdateVersionList(InBuffer buffer);

        [MethodId(36)]
        Result PushLaunchVersion(ncm.ApplicationId id, uint32_t version);

        [MethodId(37)]
        Result ListRequiredVersion(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.ns.RequiredVersionEntry> requiredVersionEntries);

        [MethodId(800)]
        Result RequestVersionList();

        [MethodId(801)]
        Result ListVersionList(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.ns.VersionListEntry> versionListEntries);

        [MethodId(802)]
        Result RequestVersionListData(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        // ApplicationRecord API
        // - MethodId: 900 - 999
        [MethodId(0)]
        Result ListApplicationRecord(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationRecord> outList, [NonNegative] int offset);

        [MethodId(1)]
        Result GenerateApplicationRecordCount(Out<int64_t> outCount);

        [MethodId(2)]
        Result GetApplicationRecordUpdateSystemEvent(Out<NativeHandle> outValue);

        [MethodId(16)]
        Result PushApplicationRecord(ncm.ApplicationId id, ApplicationEvent appEvent, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.StorageContentMetaKey> keyList);

        [MethodId(17)]
        Result ListApplicationRecordContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, ncm.ApplicationId id, [NonNegative] int offset);

        [MethodId(27)]
        Result DeleteApplicationRecord(nn.ncm.ApplicationId id);

        [MethodId(900)]
        Result GetApplicationRecord(Out<ApplicationRecord> outValue, nn.ncm.ApplicationId id);

        [MethodId(901)]
        Result GetApplicationRecordProperty([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ApplicationRecordProperty> outValue, nn.ncm.ApplicationId id);

        [MethodId(902)]
        Result EnableApplicationAutoUpdate(nn.ncm.ApplicationId id);

        [MethodId(903)]
        Result DisableApplicationAutoUpdate(nn.ncm.ApplicationId id);

        [MethodId(904)]
        Result TouchApplication(nn.ncm.ApplicationId id);

        [MethodId(905)]
        Result RequestApplicationUpdate(nn.ncm.ApplicationId id, nn.Bit32 resultInnerValue);

        [MethodId(906)]
        Result IsApplicationUpdateRequested(Out<bool> outValue, Out<nn.Bit32> resultInnerValue, nn.ncm.ApplicationId id);

        [MethodId(907)]
        Result WithdrawApplicationUpdateRequest(nn.ncm.ApplicationId id);

        [MethodId(908)]
        Result ListApplicationRecordInstalledContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, ncm.ApplicationId id, [NonNegative] int offset);

        [MethodId(909)]
        Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(nn.ncm.ApplicationId id);

        [MethodId(910)]
        Result HasApplicationRecord(Out<bool> outValue, nn.ncm.ApplicationId id);

        [MethodId(911)]
        Result SetPreInstalledApplication(nn.ncm.ApplicationId id);

        [MethodId(912)]
        Result ClearPreInstalledApplicationFlag(nn.ncm.ApplicationId id);

        // VerifyApplication API
        // - MethodId: 1000 - 1199
        [MethodId(1000)]
        Result RequestVerifyApplicationDeprecated(Out<NativeHandle> outHandle, Out<IProgressAsyncResult> outAsync, ncm.ApplicationId id, NativeHandle transferHandle, uint64_t transferSize);

        [MethodId(1001)]
        Result CorruptApplicationForDebug(nn.ncm.ApplicationId id, nn.Bit32 flags, ncm.StorageId storageId);

        [MethodId(1002)]
        Result RequestVerifyAddOnContentsRights(Out<NativeHandle> outHandle, Out<IProgressAsyncResult> outAsync, nn.ncm.ApplicationId id);

        [MethodId(1003)]
        Result RequestVerifyApplication(Out<NativeHandle> outHandle, Out<IProgressAsyncResult> outAsync, ncm.ApplicationId id, nn.Bit32 flags, NativeHandle transferHandle, uint64_t transferSize);

        [MethodId(1004)]
        Result CorruptContentForDebug(ncm.ContentMetaKey key, ncm.StorageId storageId);

        // Vulnerability API
        // - MethodId: 1200 - 1299
        // VulnerabilityManager に移行しているが、互換性のために削除してはいけない
        [MethodId(1200)]
        Result NeedsUpdateVulnerability(Out<bool> outValue);

        // ApplicationEntity API
        // - MethodId: 4 - 9, 1300 - 1399
        [MethodId(4)]
        Result DeleteApplicationEntity(nn.ncm.ApplicationId id);

        [MethodId(5)]
        Result DeleteApplicationCompletely(nn.ncm.ApplicationId id);

        [MethodId(6)]
        Result IsAnyApplicationEntityRedundant(Out<bool> outValue);

        [MethodId(7)]
        Result DeleteRedundantApplicationEntity();

        [MethodId(8)]
        Result IsApplicationEntityMovable(Out<bool> outValue, nn.ncm.ApplicationId id, nn.ncm.StorageId storage);

        [MethodId(9)]
        Result MoveApplicationEntity(nn.ncm.ApplicationId id, nn.ncm.StorageId storage);

        [MethodId(1300)]
        Result IsAnyApplicationEntityInstalled(Out<bool> outValue, nn.ncm.ApplicationId id);

        [MethodId(1301)]
        Result DeleteApplicationContentEntities(nn.ncm.ApplicationId id, uint32_t innerValue, nn.ncm.StorageId storage);

        [MethodId(1302)]
        Result CleanupUnrecordedApplicationEntity(nn.ncm.ApplicationId id);

        [MethodId(1303)]
        Result CleanupAddOnContentsWithNoRights(nn.ncm.ApplicationId id);

        [MethodId(1304)]
        Result DeleteApplicationContentEntity(nn.ncm.ContentMetaKey key);

        /* API を削除
        [MethodId(1305)]
        Result TryDeleteRunningApplicationEntity(nn.ncm.ApplicationId id);

        [MethodId(1306)]
        Result TryDeleteRunningApplicationCompletely(nn.ncm.ApplicationId id);

        [MethodId(1307)]
        Result TryDeleteRunningApplicationContentEntities(nn.ncm.ApplicationId id, uint32_t innerValue, nn.ncm.StorageId storage);
        */
        [MethodId(1308)]
        Result DeleteApplicationCompletelyForDebug(nn.ncm.ApplicationId id, uint32_t innerValue);

        // Shutdown API
        // - MethodId: 1400 - 1499
        [MethodId(1400)]
        Result PrepareShutdown();

        // SdCard API
        // - MethodId: 42-44, 49, 58, 1500 - 1599
        [MethodId(42)]
        Result CleanupSdCard();

        [MethodId(43)]
        Result CheckSdCardMountStatus();

        [MethodId(44)]
        Result GetSdCardMountStatusChangedEvent(Out<NativeHandle> outValue);

        [MethodId(49)]
        Result GetSdCardRemovedEvent(Out<NativeHandle> outValue);

        [MethodId(58)]
        Result GetLastSdCardMountUnexpectedResult();

        [MethodId(1500)]
        Result FormatSdCard();

        [MethodId(1501)]
        Result NeedsSystemUpdateToFormatSdCard(Out<bool> outValue);

        [MethodId(1502)]
        Result GetLastSdCardFormatUnexpectedResult();

        [MethodId(1504)]
        Result InsertSdCard();

        [MethodId(1505)]
        Result RemoveSdCard();

        // Pseudo Id API
        // - MethodId: 1600 - 1699
        [MethodId(1600)]
        Result GetSystemSeedForPseudoDeviceId(Out<SystemSeedForPseudoDeviceId> pOutSeed);

        [MethodId(1601)]
        Result ResetSystemSeedForPseudoDeviceId();

        // Application View API
        // - MethodId: 3, 1700 - 1799
        [MethodId(3)]
        Result GetApplicationViewDeprecated([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationViewDeprecated> outList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ApplicationId> idList);

        [MethodId(1700)]
        Result ListApplicationDownloadingContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, ncm.ApplicationId id, [NonNegative] int offset);

        [MethodId(1701)]
        Result GetApplicationView([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationView> outList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ApplicationId> idList);

        [MethodId(1702)]
        Result GetApplicationDownloadTaskStatus(Out<ApplicationDownloadTaskStatus> outValue, ncm.ApplicationId id);

        [MethodId(1703)]
        Result GetApplicationViewDownloadErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue, ncm.ApplicationId id);

        // Notification API
        // - MethodId: 3, 1800 - 1899
        [MethodId(1800)]
        Result IsNotificationSetupCompleted(Out<bool> outValue);

        [MethodId(1801)]
        Result GetLastNotificationInfoCount(Out<int64_t> outValue);

        [MethodId(1802)]
        Result ListLastNotificationInfo(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NotificationInfo> outList);

        [MethodId(1803)]
        Result ListNotificationTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<AsyncTask> outList);

        // Ticket API
        // - MethodId: 1900 - 1999
        [MethodId(1900)]
        Result IsActiveAccount(Out<bool> outValue, nn.es.AccountId accountId);

        [MethodId(1901)]
        Result RequestDownloadApplicationPrepurchasedRights(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ncm.ApplicationId id);

        [MethodId(1902)]
        Result GetApplicationTicketInfo(Out<ApplicationTicketInfo> outValue, ncm.ApplicationId id);

        // ContentDelivery API
        // - MethodId: 2000 - 2049
        [MethodId(2000)]
        Result GetSystemDeliveryInfo([BufferTransferMode(BufferTransferMode.MapAlias)] Out<SystemDeliveryInfo> outValue);

        [MethodId(2001)]
        Result SelectLatestSystemDeliveryInfo(Out<int> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<SystemDeliveryInfo> list, [BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo receiverSystemInfo, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> receiverAppInfo);

        [MethodId(2002)]
        Result VerifyDeliveryProtocolVersion([BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo info);

        [MethodId(2003)]
        Result GetApplicationDeliveryInfo(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationDeliveryInfo> outValue, ncm.ApplicationId id, ApplicationDeliveryAttribute attributes);

        [MethodId(2004)]
        Result HasAllContentsToDeliver(Out<bool> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> appInfoList);

        [MethodId(2005)]
        Result CompareApplicationDeliveryInfo(Out<int> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> lhs, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> rhs);

        [MethodId(2006)]
        Result CanDeliverApplication(Out<bool> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> receiverInfoList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> senderInfoList);

        [MethodId(2007)]
        Result ListContentMetaKeyToDeliverApplication(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.ContentMetaKey> outList, int offset, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> infoList);

        [MethodId(2008)]
        Result NeedsSystemUpdateToDeliverApplication(Out<bool> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> applicationInfoList, [BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo systemInfo);

        [MethodId(2009)]
        Result EstimateRequiredSize(Out<int64_t> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList);

        [MethodId(2010)]
        Result RequestReceiveApplication(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, uint32_t ipv4, uint16_t port, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.ApplicationId id, ncm.StorageId storageId);

        [MethodId(2011)]
        Result CommitReceiveApplication(ncm.ApplicationId id);

        [MethodId(2012)]
        Result GetReceiveApplicationProgress(Out<ReceiveApplicationProgress> outValue, ncm.ApplicationId id);

        [MethodId(2013)]
        Result RequestSendApplication(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, uint32_t ipv4, uint16_t port, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.ApplicationId id);

        [MethodId(2014)]
        Result GetSendApplicationProgress(Out<SendApplicationProgress> outValue, ncm.ApplicationId id);

        [MethodId(2015)]
        Result CompareSystemDeliveryInfo(Out<int> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo lhs, [BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo rhs);

        [MethodId(2016)]
        Result ListNotCommittedContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.ContentMetaKey> outList, ncm.ApplicationId id, int offset);

        [MethodId(2017)]
        Result CreateDownloadTask([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.ApplicationId id);

        [MethodId(2018)]
        Result GetApplicationDeliveryInfoHash(Out<ApplicationDeliveryInfoHash> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationDeliveryInfo> infoList);

        // ApplicationRights API
        // - MethodId: 2050 - 2099
        [MethodId(2050)]
        Result GetApplicationRightsOnClient(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationRightsOnClient> outList, ncm.ApplicationId appId, account.Uid uid, ApplicationRightsOnClientQueryFlag flags);

        // TerminateResult API
        // - MethodId: 2100 - 2149
        [MethodId(2100)]
        Result GetApplicationTerminateResult(Out<uint32_t> outValue, nn.ncm.ApplicationId id);

        [MethodId(2101)]
        Result GetRawApplicationTerminateResult(Out<uint32_t> outValue, nn.ncm.ApplicationId id);

        // RightsEnvironment API
        // - MethodId: 2150 - 2199

        [MethodId(2150)]
        Result CreateRightsEnvironment(Out<RightsEnvironmentHandle> pOut);

        [MethodId(2151)]
        Result DestroyRightsEnvironment(RightsEnvironmentHandle handle);

        [MethodId(2152)]
        Result ActivateRightsEnvironment(RightsEnvironmentHandle handle);

        [MethodId(2153)]
        Result DeactivateRightsEnvironment(RightsEnvironmentHandle handle);

        [MethodId(2160)]
        Result AddTargetApplicationToRightsEnvironment(RightsEnvironmentHandle handle, ncm.ApplicationId applicationId);

        [MethodId(2161)]
        Result SetUsersToRightsEnvironment(RightsEnvironmentHandle handle, bool anyUser, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<account.Uid> uids);

        [MethodId(2170)]
        Result GetRightsEnvironmentStatus(Out<RightsEnvironmentStatus> pOut, RightsEnvironmentHandle handle);

        // ApplicationCopyIdentifier API
        // - MethodId: 2200 - 2249
        [MethodId(2200)]
        Result GetGameCardApplicationCopyIdentifier([BufferTransferMode(BufferTransferMode.MapAlias)] Out<GameCardApplicationCopyIdentifier> outValue, ncm.ApplicationId id);

        [MethodId(2201)]
        Result GetInstalledApplicationCopyIdentifier([BufferTransferMode(BufferTransferMode.MapAlias)] Out<InstalledApplicationCopyIdentifier> outValue, ncm.ApplicationId id, ncm.StorageId storage);
    }

    // -----------------------------------------------------------------------------------------
    // For UserResourceManagement API
    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IProgressMonitorForDeleteUserSaveDataAll : IServiceObject
    {
        [MethodId(0)]
        Result GetSystemEvent(Out<NativeHandle> pOut);

        [MethodId(1)]
        Result IsFinished(Out<bool> pOut);

        [MethodId(2)]
        Result GetResult();

        [MethodId(10)]
        Result GetProgress(Out<ProgressForDeleteUserSaveDataAll> pOut);
    }
    // ~For UserResourceManagement API
    // -----------------------------------------------------------------------------------------

    // -----------------------------------------------------------------------------------------
    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IGameCardStopper : IServiceObject
    {
    }
    // -----------------------------------------------------------------------------------------

    // -----------------------------------------------------------------------------------------
    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IRequestServerStopper : IServiceObject
    {
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IServiceGetterInterface : IServiceObject
    {
        [MethodId(7999)]
        Result GetDocumentInterface(Out<IDocumentInterface> outValue);

        [MethodId(7998)]
        Result GetContentManagementInterface(Out<IContentManagementInterface> outValue);

        [MethodId(7997)]
        Result GetDownloadTaskInterface(Out<IDownloadTaskInterface> outValue);

        [MethodId(7996)]
        Result GetApplicationManagerInterface(Out<IApplicationManagerInterface> outValue);

        [MethodId(7995)]
        Result GetAccountProxyInterface(Out<IAccountProxyInterface> outValue);

        [MethodId(7994)]
        Result GetFactoryResetInterface(Out<IFactoryResetInterface> outValue);

        [MethodId(7993)]
        Result GetApplicationVersionInterface(Out<IApplicationVersionInterface> outValue);

        [MethodId(7992)]
        Result GetECommerceInterface(Out<IECommerceInterface> outValue);

        [MethodId(7991)]
        Result GetReadOnlyApplicationRecordInterface(Out<IReadOnlyApplicationRecordInterface> outValue);

        [MethodId(7989)]
        Result GetReadOnlyApplicationControlDataInterface(Out<IReadOnlyApplicationControlDataInterface> outValue);

        [MethodId(7988)]
        Result GetDynamicRightsInterface(Out<IDynamicRightsInterface> outValue);
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IContentManagementInterface : IServiceObject
    {
        // for content management
        [MethodId(11)]
        Result CalculateApplicationOccupiedSize(Out<ApplicationOccupiedSize> outValue, nn.ncm.ApplicationId id);

        [MethodId(43)]
        Result CheckSdCardMountStatus();

        [MethodId(47)]
        Result GetTotalSpaceSize(Out<int64_t> outSize, nn.ncm.StorageId storage);

        [MethodId(48)]
        Result GetFreeSpaceSize(Out<int64_t> outSize, nn.ncm.StorageId storage);

        [MethodId(600)]
        Result CountApplicationContentMeta(Out<int> outValue, nn.ncm.ApplicationId appId);

        [MethodId(601)]
        Result ListApplicationContentMetaStatus(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationContentMetaStatus> outList, nn.ncm.ApplicationId appId, int offset);

        [MethodId(605)]
        Result ListApplicationContentMetaStatusWithRightsCheck(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplicationContentMetaStatus> outList, nn.ncm.ApplicationId appId, int offset);

        [MethodId(607)]
        bool IsAnyApplicationRunning();
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IDownloadTaskInterface : IServiceObject
    {
        // for download task
        [MethodId(701)]
        Result ClearTaskStatusList();

        [MethodId(702)]
        Result RequestDownloadTaskList();

        [MethodId(703)]
        Result RequestEnsureDownloadTask(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(704)]
        Result ListDownloadTaskStatus(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<DownloadTaskStatus> outList);

        [MethodId(705)]
        Result RequestDownloadTaskListData(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(706)]
        Result TryCommitCurrentApplicationDownloadTask();

        [MethodId(707)]
        void EnableAutoCommit();

        [MethodId(708)]
        void DisableAutoCommit();

        [MethodId(709)]
        Result TriggerDynamicCommitEvent();
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IDocumentInterface : IServiceObject
    {
        // for MountApplicationLegalInformation
        [MethodId(21)]
        Result GetApplicationContentPath([BufferTransferMode(BufferTransferMode.MapAlias)] Out<nn.ncm.Path> outValue, nn.ncm.ApplicationId id, nn.ncm.ContentType type);

        // for MountApplicationHtmlDocument
        [MethodId(23)]
        Result ResolveApplicationContentPath(nn.ncm.ProgramId id, nn.ncm.ContentType type);

        [MethodId(92)]
        Result GetRunningApplicationProgramId(Out<ncm.ProgramId> outValue, ncm.ApplicationId id);
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IAccountProxyInterface : IServiceObject
    {
        [MethodId(0)]
        Result CreateUserAccount(account.Nickname name, InBuffer image);
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IFactoryResetInterface : IServiceObject
    {
        [MethodId(100)]
        Result ResetToFactorySettings();

        [MethodId(101)]
        Result ResetToFactorySettingsWithoutUserSaveData();

        [MethodId(102)]
        Result ResetToFactorySettingsForRefurbishment();
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IApplicationVersionInterface : IServiceObject
    {
        [MethodId(0)]
        Result GetLaunchRequiredVersion(Out<uint32_t> outValue, nn.ncm.ApplicationId id);

        [MethodId(1)]
        Result UpgradeLaunchRequiredVersion(nn.ncm.ApplicationId id, uint32_t launchRequiredVersion);

        [MethodId(35)]
        Result UpdateVersionList(InBuffer buffer);

        [MethodId(36)]
        Result PushLaunchVersion(ncm.ApplicationId id, uint32_t version);

        [MethodId(37)]
        Result ListRequiredVersion(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.ns.RequiredVersionEntry> requiredVersionEntries);

        [MethodId(800)]
        Result RequestVersionList();

        [MethodId(801)]
        Result ListVersionList(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.ns.VersionListEntry> versionListEntries);

        [MethodId(802)]
        Result RequestVersionListData(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(1000)]
        Result PerformAutoUpdate();
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IECommerceInterface : IServiceObject
    {
        [MethodId(0)]
        Result RequestLinkDevice(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.Uid uid);

        [MethodId(1)]
        Result RequestCleanupAllPreInstalledApplications(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(2)]
        Result RequestCleanupPreInstalledApplication(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.ncm.ApplicationId id);

        [MethodId(3)]
        Result RequestSyncRights(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IReadOnlyApplicationRecordInterface : IServiceObject
    {
        [MethodId(0)]
        Result HasApplicationRecord(Out<bool> outValue, nn.ncm.ApplicationId id);
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IReadOnlyApplicationControlDataInterface : IServiceObject
    {
        [MethodId(0)]
        Result GetApplicationControlData(Out<uint32_t> outValue, OutBuffer buffer, ApplicationControlSource source, nn.ncm.ApplicationId id);

        [MethodId(1)]
        Result GetApplicationDesiredLanguage(Out<nn.Bit8> outValue, nn.Bit32 supportedLanguageFlag);

        [MethodId(2)]
        Result ConvertApplicationLanguageToLanguageCode(Out<nn.settings.LanguageCode> outValue, nn.Bit8 language);

        [MethodId(3)]
        Result ConvertLanguageCodeToApplicationLanguage(Out<nn.Bit8> outValue, nn.settings.LanguageCode code);
    }

    [CppRefPath("<nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>")]
    public interface IDynamicRightsInterface : IServiceObject
    {
        [MethodId(0)]
        Result RequestApplicationRightsOnServer(Out<NativeHandle> outHandle, Out<IAsyncValue> outValue, nn.ncm.ApplicationId id, nn.account.Uid uid, Bit32 flags);

        [MethodId(1)]
        Result RequestAssignRights(Out<NativeHandle> outHandle, Out<IAsyncResult> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ApplicationRightsOnServer> list);

        [MethodId(2)]
        Result RegisterUserOfAccountRestrictedRights(nn.account.Uid uid);

        [MethodId(3)]
        Result UnregisterAllUsersOfAccountRestrictedRights();

        [MethodId(4)]
        Result RequestAssignRightsToResume(Out<NativeHandle> outHandle, Out<IAsyncResult> outValue, RightsEnvironmentHandle handle, nn.account.Uid uid);

        [MethodId(5)]
        Result VerifyActivatedRightsOwners(RightsEnvironmentHandle handle);

        [MethodId(6)]
        Result GetApplicationRightsStatus(Out<ApplicationRightsStatus> outValue, RightsEnvironmentHandle handle);
    }
}
