﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_AppletLauncherApi.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {
    void GetApplicationShellEvent(os::SystemEvent* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetApplicationShellEvent(&nativeHandle));

        outValue->AttachReadableHandle(nativeHandle.GetOsHandle(), nativeHandle.IsManaged(), os::EventClearMode_AutoClear);
        nativeHandle.Detach();
    }

    int PopApplicationShellEventInfo(ApplicationShellEventInfo outList[], int count) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->PopApplicationShellEventInfo(&outCount, sf::OutArray<ApplicationShellEventInfo>(outList, static_cast<size_t>(count))));
        return outCount;
    }

    Result LaunchLibraryApplet(os::ProcessId* outValue, ncm::SystemProgramId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->LaunchLibraryApplet(outValue, id);
    }

    Result TerminateLibraryApplet(os::ProcessId pid) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->TerminateLibraryApplet(pid);
    }

    Result LaunchSystemApplet(os::ProcessId* outValue) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->LaunchSystemApplet(outValue);
    }

    Result TerminateSystemApplet(os::ProcessId pid) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->TerminateSystemApplet(pid);
    }

    Result LaunchOverlayApplet(os::ProcessId* outValue) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->LaunchOverlayApplet(outValue);
    }

    Result TerminateOverlayApplet(os::ProcessId pid) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->TerminateOverlayApplet(pid);
    }

}}  // namespace ns
