﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Mount.h>
#include <nn/nim/srv/nim_TemporaryDataStore.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace nim { namespace srv {

    Result TemporaryDataStore::Initialize(const char* mountName, fs::SystemSaveDataId id, int64_t saveDataSize, int64_t saveDataJournalSize, int saveDataFlags) NN_NOEXCEPT
    {
        nn::fs::DisableAutoSaveDataCreation();
        NN_RESULT_TRY(fs::MountSystemSaveData(mountName, id))
            NN_RESULT_CATCH(nn::fs::ResultTargetNotFound)
            {
                NN_RESULT_DO(nn::fs::CreateSystemSaveData(id, saveDataSize, saveDataJournalSize, saveDataFlags));
                NN_RESULT_DO(nn::fs::MountSystemSaveData(mountName, id));
            }
        NN_RESULT_END_TRY;

        m_MoundName.emplace();
        m_MoundName->Assign(mountName);

        NN_RESULT_SUCCESS;
    }

    TemporaryDataStore::~TemporaryDataStore() NN_NOEXCEPT
    {
        if (m_MoundName)
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(fs::CommitSaveData(*m_MoundName));
            fs::Unmount(*m_MoundName);
        }
    }

    TemporaryDataStore::Path TemporaryDataStore::GenerateTemporaryFilePath() const NN_NOEXCEPT
    {
        char uuidString[util::Uuid::StringSize];
        Path path;
        path.AssignFormat("%s:/%s", m_MoundName->Get(), util::GenerateUuid().ToString(uuidString, sizeof(uuidString)));
        return path;
    }
}}}
