﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nim_DynamicRightsCommon.h"
#include <nn/es/es_ELicenseApi.h>

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

/**
 * @brief   nim::RequestSyncELicenses 用 Async ハンドル
 */
class AsyncSyncELicensesImpl : public AsyncResultImpl<AsyncSyncELicensesImpl>, public DragonsAsyncAccessTaskBase
{
public:
    typedef DragonsAsyncAccessTaskBase              Executor;
    typedef AsyncResultImpl<AsyncSyncELicensesImpl> AsyncBase;
    typedef ::nn::account::NintendoAccountId        AccountId;

    AsyncSyncELicensesImpl() NN_NOEXCEPT;
    ~AsyncSyncELicensesImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, const AccountId& accountId) NN_NOEXCEPT;

    Result Execute() NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

private:
    Result OnExecute() NN_NOEXCEPT;

    AccountId   m_AccountId;
};

/**
 * @brief   Dragons ライセンスアーカイブ発行 API アクセスプロファイル。
 */
class ELicenseArchiveProfile : public DragonsAsyncAccessTaskBase::RequestProfileHolder
{
private:
    typedef DragonsAsyncAccessTaskBase::ConnectionType  ConnectionType;
    typedef DragonsAsyncAccessTaskBase::AccessProfile   AccessProfile;
    typedef DragonsAsyncAccessTaskBase::InputStream     InputStream;

    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

public:
    typedef ::nn::es::ELicenseImportContext     ImportContext;
    typedef ::nn::account::NintendoAccountId    AccountId;

    explicit ELicenseArchiveProfile(const AccountId& accountId, ImportContext* pContext) NN_NOEXCEPT;

private:
    ImportContext* const    m_pImportContext;
    AccountId               m_AccountId;
};

/**
 * @brief   Dragons ライセンスアーカイブ同期完了報告 API アクセスプロファイル。
 */
class ELicenseSyncDoneProfile : public DragonsAsyncAccessTaskBase::RequestProfileHolder
{
private:
    typedef DragonsAsyncAccessTaskBase::ConnectionType  ConnectionType;
    typedef DragonsAsyncAccessTaskBase::AccessProfile   AccessProfile;
    typedef DragonsAsyncAccessTaskBase::InputStream     InputStream;

    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

public:
    typedef ::nn::es::ELicenseImportContext     ImportContext;
    typedef ::nn::es::ELicenseArchiveId         ArchiveId;
    typedef ::nn::account::NintendoAccountId    AccountId;

    explicit ELicenseSyncDoneProfile(const AccountId& accountId) NN_NOEXCEPT;

    Result BeginImport(ImportContext** pOutContext) NN_NOEXCEPT;
    Result EndImport() NN_NOEXCEPT;

private:
    AccountId                       m_AccountId;
    ArchiveId                       m_ArchiveId;
    ImportContext                   m_ImportContext;
};

}   // ~DynamicRights

}}}
