﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nim_DynamicRightsCommon.h"

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

/**
 * @brief   nim::RequestQueryRevokeReason 用 Async ハンドル
 */
class AsyncRevokeReasonImpl : public AsyncResultImpl<AsyncRevokeReasonImpl>, public DragonsAccessAsyncImpl
{
    typedef AsyncResultImpl<AsyncRevokeReasonImpl>  AsyncBase;
    typedef DragonsAccessAsyncImpl                  Executor;

public:
    typedef ::nn::nim::RevokeReason             ValueType;
    typedef ::nn::es::ELicenseId                ELicenseId;
    typedef ::nn::account::NintendoAccountId    AccountId;

    AsyncRevokeReasonImpl() NN_NOEXCEPT;
    ~AsyncRevokeReasonImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, const AccountId& accountId, const ELicenseId& eLicenseId) NN_NOEXCEPT;
    Result GetSize(::nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
    Result Get(const ::nn::sf::OutBuffer& buffer) const NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

protected:
    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

private:
    ELicenseId  m_ELicenseId;
    AccountId   m_AccountId;
    ValueType   m_Value;
};


}   // ~DynamicRights

}}}
