﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nim_DynamicRightsCommon.h"

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

//---------------------------------------------------------------------------------------
/**
 * @brief   nim::RequestReportActiveELicenses 用 Async 基底ハンドル
 */
class AsyncReportELicensesImplBase : public DragonsAccessAsyncImpl
{
public:
    Result Initialize(DeviceContext* pDeviceContext, const ::nn::account::NintendoAccountId& naId, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds, const char* pTemporaryFilePath) NN_NOEXCEPT;

protected:
    typedef DragonsAccessAsyncImpl  Executor;

    AsyncReportELicensesImplBase() NN_NOEXCEPT;
    ~AsyncReportELicensesImplBase() NN_NOEXCEPT;

    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

    virtual Result OnQueryAccessPathUrl(char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT = 0;

private:
    TemporaryFileStore                  m_ValueStore;
    HeapUtil::OnetimeHeapSession        m_Post;
    ::nn::account::NintendoAccountId    m_AccountId;
};

//---------------------------------------------------------------------------------------
/**
 * @brief   nim::RequestReportActiveELicenses 用 Async ハンドル
 */
class AsyncReportELicensesImpl : public AsyncResultImpl<AsyncReportELicensesImpl>, public AsyncReportELicensesImplBase
{
private:
    typedef AsyncResultImpl<AsyncReportELicensesImpl>   AsyncBase;

public:
    AsyncReportELicensesImpl() NN_NOEXCEPT;
    ~AsyncReportELicensesImpl() NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

protected:
    virtual Result OnQueryAccessPathUrl(char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
};

//---------------------------------------------------------------------------------------
/**
 * @brief   nim::RequestReportActiveELicensesPassively 用 Async ハンドル
 */
class AsyncReportELicensesPassivelyImpl : public AsyncResultImpl<AsyncReportELicensesPassivelyImpl>, public AsyncReportELicensesImplBase
{
private:
    typedef AsyncResultImpl<AsyncReportELicensesPassivelyImpl>  AsyncBase;

public:
    AsyncReportELicensesPassivelyImpl() NN_NOEXCEPT;
    ~AsyncReportELicensesPassivelyImpl() NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

protected:
    virtual Result OnQueryAccessPathUrl(char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
};

}   // ~DynamicRights

}}}
