﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nim_DynamicRightsCommon.h"
#include <nn/npns/npns_Types.h>

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

/**
 * @brief   nim::RequestRegisterDynamicRightsNotificationToken 用 Async ハンドル
 */
class AsyncRegisterNotificationTokenImpl : public AsyncResultImpl<AsyncRegisterNotificationTokenImpl>, public DragonsAccessAsyncImpl
{
    typedef AsyncResultImpl<AsyncRegisterNotificationTokenImpl> AsyncBase;
    typedef DragonsAccessAsyncImpl                              Executor;

public:
    AsyncRegisterNotificationTokenImpl() NN_NOEXCEPT;
    ~AsyncRegisterNotificationTokenImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, const ::nn::npns::NotificationToken& notificationToken) NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

protected:
    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

private:
    HeapUtil::OnetimeHeapSession    m_Post;
    ::nn::npns::NotificationToken   m_Token;
};

}   // ~DynamicRights

}}}
