﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nim/srv/nim_DeviceAccountStore.h>
#include "nim_DynamicRightsCommon.h"

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

/**
 * @brief   Dragons 動的 eTicket 取得用トークン要求 API アクセスプロファイル。
 */
class ETicketsTokenProfile : public DragonsAsyncAccessTaskBase::RequestProfileHolder
{
    NN_DISALLOW_COPY(ETicketsTokenProfile);
    NN_DISALLOW_MOVE(ETicketsTokenProfile);

private:
    typedef DragonsAsyncAccessTaskBase::ConnectionType  ConnectionType;
    typedef DragonsAsyncAccessTaskBase::AccessProfile   AccessProfile;
    typedef DragonsAsyncAccessTaskBase::InputStream     InputStream;

    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

public:
    //! @brief  コンストラクタ。
    ETicketsTokenProfile(char* pOutTokenBuffer, size_t tokenBufferCapacity, const ::nn::account::Uid& uid, TemporaryFileStore* pELicenseIdsStore) NN_NOEXCEPT;

    //! @brief  要求対象にする入力 eLicenseIds 中の開始インデクスと要求数。
    Result RequestRange(size_t index, size_t count) NN_NOEXCEPT;

private:
    char* const                     m_pTokenBuffer;
    TemporaryFileStore* const       m_pValueStore;
    HeapUtil::OnetimeHeapSession    m_Post;
    ::nn::account::Uid              m_User;
    size_t                          m_StartIndex;
    size_t                          m_RangeCount;
    size_t                          m_TokenBufferCapacity;
};

/**
 * @brief   nim::RequestDownloadETickets 用 Async ハンドル
 */
class AsyncDownloadETicketsImpl : public AsyncResultImpl<AsyncDownloadETicketsImpl>, public DragonsAsyncAccessTaskBase
{
    NN_DISALLOW_COPY(AsyncDownloadETicketsImpl);
    NN_DISALLOW_MOVE(AsyncDownloadETicketsImpl);

public:
    typedef DragonsAsyncAccessTaskBase                  Executor;
    typedef AsyncResultImpl<AsyncDownloadETicketsImpl>  AsyncBase;
    typedef ::nn::account::NintendoAccountId            AccountId;

    AsyncDownloadETicketsImpl() NN_NOEXCEPT;
    ~AsyncDownloadETicketsImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, DeviceAccountStore* pDeviceAccountStore, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::ELicenseId>& elicenseIds, const char* pTemporaryFilePath) NN_NOEXCEPT;

    Result Execute() NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

private:
    Result OnExecute() NN_NOEXCEPT;

    DeviceContext*      m_pDeviceContext;
    DeviceAccountStore* m_pDeviceAccountStore;
    TemporaryFileStore  m_ValueStore;
    ::nn::account::Uid  m_User;
};



}   // ~DynamicRights

}}}
