﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nim_DynamicRightsCommon.h"

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

/**
 * @brief   nim::RequestQueryAvailableELicenses 用 Async ハンドル
 */
class AsyncAvailableELicensesImpl : public AsyncResultImpl<AsyncAvailableELicensesImpl>, public DragonsAccessAsyncImpl
{
private:
    typedef AsyncResultImpl<AsyncAvailableELicensesImpl>    AsyncBase;
    typedef DragonsAccessAsyncImpl                          Executor;
    typedef uint16_t                                        CountType;

public:
    AsyncAvailableELicensesImpl() NN_NOEXCEPT;
    ~AsyncAvailableELicensesImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds, const char* pTemporaryFilePath) NN_NOEXCEPT;
    Result GetSize(::nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    Result Read(::nn::sf::Out<std::uint64_t> outValue, int64_t offset, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

    //! @brief  未使用
    Result GetETag(::nn::sf::Out<::nn::nim::ETag>) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

protected:
    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

private:
    TemporaryFileStore              m_ValueStore;
    HeapUtil::OnetimeHeapSession    m_Post;
    ::nn::account::Uid              m_User;
    CountType                       m_Count;        //!< 有効なライセンス数
};

}   // ~DynamicRights

}}}
