﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/nim/nim_Result.h>
#include <nn/nn_SystemThreadDefinition.h>
#include "nim_AsyncTaskBufferAllocator.h"
#include "nim_AsyncTaskResultImpl.h"

namespace nn { namespace nim { namespace srv {

    namespace
    {
        static const int SystemUpdateThreadCount = 1;
        static const int NetworkInstallThreadCount = 1;
        static const int ApplyDeltaThreadCount = 1;
        static const int LocalCommunicationReceiveThreadCount = 1;
        static const int LocalCommunicationSendThreadCount = 1;
        static const size_t SystemUpdateThreadStackSize = 16 * 1024;
        static const size_t NetworkInstallThreadStackSize = 32 * 1024;
        static const size_t ApplyDeltaThreadStackSize = 16 * 1024;

        os::ThreadType g_SystemUpdateTaskThreadList[SystemUpdateThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_SystemUpdateTaskStack[SystemUpdateThreadStackSize * SystemUpdateThreadCount];
        os::ThreadType g_NetworkInstallTaskThreadList[NetworkInstallThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_NetworkInstallTaskStack[NetworkInstallThreadStackSize * NetworkInstallThreadCount];
        os::ThreadType g_ApplyDeltaTaskThreadList[ApplyDeltaThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_ApplyDeltaTaskStack[ApplyDeltaThreadStackSize * ApplyDeltaThreadCount];

        os::ThreadType g_LocalCommunicationReceiveApplicationTaskThreadList[LocalCommunicationReceiveThreadCount];
        os::ThreadType g_LocalCommunicationSendApplicationTaskThreadList[LocalCommunicationSendThreadCount];
        os::ThreadType g_LocalCommunicationReceiveSystemUpdateTaskThreadList[LocalCommunicationReceiveThreadCount];
        os::ThreadType g_LocalCommunicationSendSystemUpdateTaskThreadList[LocalCommunicationSendThreadCount];

        // ローカルコンテンツ配信を実行しているときは、ネットワークタスクは終了しているはずなので、スタックを再利用させてもらう
        // NN_OS_ALIGNAS_THREAD_STACK char g_LocalCommunicationReceiveApplicationTaskStack[NetworkInstallThreadStackSize * LocalCommunicationReceiveThreadCount];
        // NN_OS_ALIGNAS_THREAD_STACK char g_LocalCommunicationSendStack[NetworkInstallThreadStackSize * LocalCommunicationSendThreadCount];
        // NN_OS_ALIGNAS_THREAD_STACK char g_LocalCommunicationReceiveSystemUpdateTaskStack[SystemUpdateThreadStackSize * LocalCommunicationReceiveThreadCount];
        // NN_OS_ALIGNAS_THREAD_STACK char g_LocalCommunicationSendSystemUpdateTaskStack[SystemUpdateThreadStackSize * LocalCommunicationSendThreadCount];

        ThreadAllocator g_SystemUpdateTaskThreadAllocator(g_SystemUpdateTaskThreadList, SystemUpdateThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, SystemUpdateTask), g_SystemUpdateTaskStack, sizeof(g_SystemUpdateTaskStack), SystemUpdateThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, SystemUpdateTask));
        ThreadAllocator g_NetworkInstallTaskThreadAllocator(g_NetworkInstallTaskThreadList, NetworkInstallThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, NetworkInstallTask), g_NetworkInstallTaskStack, sizeof(g_NetworkInstallTaskStack), NetworkInstallThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, NetworkInstallTask));
        ThreadAllocator g_ApplyDeltaTaskThreadAllocator(g_ApplyDeltaTaskThreadList, ApplyDeltaThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, ApplyDeltaTask), g_ApplyDeltaTaskStack, sizeof(g_ApplyDeltaTaskStack), ApplyDeltaThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, ApplyDeltaTask));

        // ローカルコンテンツ配信を実行しているときは、ネットワークタスクは終了しているはずなので、スタックを再利用させてもらう
        ThreadAllocator g_LocalCommunicationReceiveApplicationTaskThreadAllocator(g_LocalCommunicationReceiveApplicationTaskThreadList, LocalCommunicationReceiveThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, LocalCommunicationReceiveApplicationTask), g_NetworkInstallTaskStack, sizeof(g_NetworkInstallTaskStack), NetworkInstallThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, LocalCommunicationReceiveApplicationTask));
        ThreadAllocator g_LocalCommunicationSendApplicationTaskThreadAllocator(g_LocalCommunicationSendApplicationTaskThreadList, LocalCommunicationSendThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, LocalCommunicationSendApplicationTask), g_NetworkInstallTaskStack, sizeof(g_NetworkInstallTaskStack), NetworkInstallThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, LocalCommunicationSendApplicationTask));
        ThreadAllocator g_LocalCommunicationReceiveSystemUpdateTaskThreadAllocator(g_LocalCommunicationReceiveSystemUpdateTaskThreadList, LocalCommunicationReceiveThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, LocalCommunicationReceiveSystemUpdateTask), g_SystemUpdateTaskStack, sizeof(g_SystemUpdateTaskStack), SystemUpdateThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, LocalCommunicationReceiveSystemUpdateTask));
        ThreadAllocator g_LocalCommunicationSendSystemUpdateTaskThreadAllocator(g_LocalCommunicationSendSystemUpdateTaskThreadList, LocalCommunicationSendThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, LocalCommunicationSendSystemUpdateTask), g_SystemUpdateTaskStack, sizeof(g_SystemUpdateTaskStack), SystemUpdateThreadStackSize, NN_SYSTEM_THREAD_NAME(nim, LocalCommunicationSendSystemUpdateTask));
    }

    AsyncNetworkSystemUpdateTaskResultImpl::AsyncNetworkSystemUpdateTaskResultImpl(SystemUpdateTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_SystemUpdateTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), NetworkSystemUpdateTaskBufferFlag::Mask, fs::PriorityRaw_Background) {}

    AsyncNetworkInstallTaskResultImpl::AsyncNetworkInstallTaskResultImpl(NetworkInstallTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_NetworkInstallTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), NetworkInstallTaskBufferFlag::Mask, fs::PriorityRaw_Background) {}

    AsyncApplyDeltaTaskResultImpl::AsyncApplyDeltaTaskResultImpl(ApplyDeltaTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_ApplyDeltaTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), ApplyDeltaTaskBufferFlag::Mask, fs::PriorityRaw_Background) {}

    AsyncLocalCommunicationReceiveApplicationTaskResultImpl::AsyncLocalCommunicationReceiveApplicationTaskResultImpl(LocalCommunicationReceiveApplicationTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_LocalCommunicationReceiveApplicationTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), LocalCommunicationReceiveApplicationTaskBufferFlag::Mask, fs::PriorityRaw_Normal) {}

    AsyncLocalCommunicationSendApplicationTaskResultImpl::AsyncLocalCommunicationSendApplicationTaskResultImpl(LocalCommunicationSendApplicationTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_LocalCommunicationSendApplicationTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), LocalCommunicationSendApplicationTaskBufferFlag::Mask, fs::PriorityRaw_Normal) {}

    AsyncLocalCommunicationReceiveSystemUpdateTaskResultImpl::AsyncLocalCommunicationReceiveSystemUpdateTaskResultImpl(LocalCommunicationReceiveSystemUpdateTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_LocalCommunicationReceiveSystemUpdateTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), LocalCommunicationReceiveSystemUpdateTaskBufferFlag::Mask, fs::PriorityRaw_Normal) {}

    AsyncLocalCommunicationSendSystemUpdateTaskResultImpl::AsyncLocalCommunicationSendSystemUpdateTaskResultImpl(LocalCommunicationSendSystemUpdateTaskHolder* holder) NN_NOEXCEPT :
        AsyncTaskResultImpl(&g_LocalCommunicationSendSystemUpdateTaskThreadAllocator, holder, GetAsyncTaskBufferAllocator(), LocalCommunicationSendSystemUpdateTaskBufferFlag::Mask, fs::PriorityRaw_Normal) {}
}}}
