﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/npns/npns_Types.h>
#include <nn/util/util_Execution.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    class AsyncRegisterNotificationTokenImpl : public AsyncResultImpl<AsyncRegisterNotificationTokenImpl>
    {
    public:
        AsyncRegisterNotificationTokenImpl() NN_NOEXCEPT;
        ~AsyncRegisterNotificationTokenImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncRegisterNotificationTokenImpl>::Join();
        }

        Result Initialize(const npns::NotificationToken& notificationToken, DeviceContext* deviceContext) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_HttpConnection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        DeviceContext* m_pDeviceContext;
        npns::NotificationToken m_NotificationToken;
        HttpConnection m_HttpConnection;
        util::Cancelable m_Cancelable;
    };

}}}
