﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/dauth/dauth_Api.h>
#include <nn/nim/srv/nim_DeviceAuthenticationTokenInfoCache.h>
#include <nn/util/util_Execution.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {

    class AsyncDeviceAuthenticationTokenImpl : public AsyncValueImpl<AsyncDeviceAuthenticationTokenImpl, ec::system::DeviceAuthenticationToken>
    {
    public:
        AsyncDeviceAuthenticationTokenImpl() NN_NOEXCEPT;
        virtual ~AsyncDeviceAuthenticationTokenImpl() NN_NOEXCEPT
        {
            Join();
        };

        Result Initialize(DeviceAuthenticationTokenInfoCache* cachedToken) NN_NOEXCEPT;

        // 引数に与えられた時間よりも有効期間が長いトークンをキャッシュしていた場合、そのトークンを取得する設定を有効化する
        void EnableCachedToken(TimeSpan remainingTime) NN_NOEXCEPT;

        virtual Result ExecuteAndValue(ec::system::DeviceAuthenticationToken* outValue) NN_NOEXCEPT;
        Result CancelImpl() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = {};
            NN_RESULT_SUCCESS;
        }

    private:
        bool CanReturnCachedDeviceAuthenticationToken() NN_NOEXCEPT;

        util::Cancelable m_Cancelable;
        DeviceAuthenticationTokenInfoCache* m_pCachedTokenInfo;
        TimeSpan m_RemainingTime;
        bool m_IsCacheEnabled;
    };

}}}
